"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePostPushToService = void 0;
var _react = require("react");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataFetchReducer = (state, action) => {
  switch (action.type) {
    case 'FETCH_INIT':
      return {
        ...state,
        isLoading: true,
        isError: false
      };
    case 'FETCH_SUCCESS':
      return {
        ...state,
        isLoading: false,
        isError: false
      };
    case 'FETCH_FAILURE':
      return {
        ...state,
        isLoading: false,
        isError: true
      };
    default:
      return state;
  }
};
const usePostPushToService = () => {
  const [state, dispatch] = (0, _react.useReducer)(dataFetchReducer, {
    isLoading: false,
    isError: false
  });
  const toasts = (0, _kibana.useToasts)();
  const cancel = (0, _react.useRef)(false);
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  const pushCaseToExternalService = (0, _react.useCallback)(async ({
    caseId,
    connector
  }) => {
    try {
      abortCtrlRef.current.abort();
      cancel.current = false;
      abortCtrlRef.current = new AbortController();
      dispatch({
        type: 'FETCH_INIT'
      });
      const response = await (0, _api.pushCase)(caseId, connector.id, abortCtrlRef.current.signal);
      if (!cancel.current) {
        dispatch({
          type: 'FETCH_SUCCESS'
        });
        toasts.addSuccess({
          title: i18n.SUCCESS_SEND_TO_EXTERNAL_SERVICE(connector.name),
          className: 'eui-textBreakWord'
        });
      }
      return response;
    } catch (error) {
      if (!cancel.current) {
        if (error.name !== 'AbortError') {
          toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
            title: i18n.ERROR_TITLE
          });
        }
        dispatch({
          type: 'FETCH_FAILURE'
        });
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  (0, _react.useEffect)(() => () => {
    abortCtrlRef.current.abort();
    cancel.current = true;
  }, []);
  return {
    ...state,
    pushCaseToExternalService
  };
};
exports.usePostPushToService = usePostPushToService;