"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetCaseUserActionsStats = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api = require("./api");
var _use_cases_toast = require("../common/use_cases_toast");
var _translations = require("./translations");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetCaseUserActionsStats = caseId => {
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  const abortCtrlRef = new AbortController();
  return (0, _reactQuery.useQuery)(_constants.casesQueriesKeys.caseUserActionsStats(caseId), () => {
    return (0, _api.getCaseUserActionsStats)(caseId, abortCtrlRef.signal);
  }, {
    onError: error => {
      showErrorToast(error, {
        title: _translations.ERROR_TITLE
      });
    }
  });
};
exports.useGetCaseUserActionsStats = useGetCaseUserActionsStats;