"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetCaseMetrics = void 0;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../common/lib/kibana");
var _api = require("./api");
var _translations = require("./translations");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetCaseMetrics = (caseId, features) => {
  const toasts = (0, _kibana.useToasts)();
  const abortCtrlRef = new AbortController();
  return (0, _reactQuery.useQuery)(_constants.casesQueriesKeys.caseMetrics(caseId, features), async () => {
    const response = await (0, _api.getSingleCaseMetrics)(caseId, features, abortCtrlRef.signal);
    return {
      metrics: response
    };
  }, {
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: _translations.ERROR_TITLE
        });
      }
    }
  });
};
exports.useGetCaseMetrics = useGetCaseMetrics;