"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateCases = void 0;
var _reactQuery = require("@tanstack/react-query");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("./api");
var _use_cases_toast = require("../common/use_cases_toast");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateCases = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    showErrorToast,
    showSuccessToast
  } = (0, _use_cases_toast.useCasesToast)();
  return (0, _reactQuery.useMutation)(({
    cases
  }) => {
    const abortCtrlRef = new AbortController();
    return (0, _api.updateCases)(cases, abortCtrlRef.signal);
  }, {
    mutationKey: _constants.casesMutationsKeys.updateCases,
    onSuccess: (_, {
      successToasterTitle
    }) => {
      queryClient.invalidateQueries(_constants.casesQueriesKeys.casesList());
      queryClient.invalidateQueries(_constants.casesQueriesKeys.tags());
      queryClient.invalidateQueries(_constants.casesQueriesKeys.userProfiles());
      showSuccessToast(successToasterTitle);
    },
    onError: error => {
      showErrorToast(error, {
        title: i18n.ERROR_UPDATING
      });
    }
  });
};
exports.useUpdateCases = useUpdateCases;