"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.casesQueriesKeys = exports.casesMutationsKeys = exports.DEFAULT_TABLE_LIMIT = exports.DEFAULT_TABLE_ACTIVE_PAGE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TABLE_ACTIVE_PAGE = 1;
exports.DEFAULT_TABLE_ACTIVE_PAGE = DEFAULT_TABLE_ACTIVE_PAGE;
const DEFAULT_TABLE_LIMIT = 10;
exports.DEFAULT_TABLE_LIMIT = DEFAULT_TABLE_LIMIT;
const casesQueriesKeys = {
  all: ['cases'],
  users: ['users'],
  connectors: ['connectors'],
  alerts: ['alerts'],
  userActions: ['user-actions'],
  connectorsList: () => [...casesQueriesKeys.connectors, 'list'],
  casesList: () => [...casesQueriesKeys.all, 'list'],
  casesMetrics: () => [...casesQueriesKeys.casesList(), 'metrics'],
  casesStatuses: () => [...casesQueriesKeys.casesList(), 'statuses'],
  cases: params => [...casesQueriesKeys.casesList(), 'all-cases', params],
  caseView: () => [...casesQueriesKeys.all, 'case'],
  case: id => [...casesQueriesKeys.caseView(), id],
  caseFiles: (id, params) => [...casesQueriesKeys.case(id), 'files', params],
  caseFileStats: id => [...casesQueriesKeys.case(id), 'files', 'stats'],
  caseMetrics: (id, features) => [...casesQueriesKeys.case(id), 'metrics', features],
  caseConnectors: id => [...casesQueriesKeys.case(id), 'connectors'],
  caseUsers: id => [...casesQueriesKeys.case(id), 'users'],
  caseUserActions: (id, params) => [...casesQueriesKeys.case(id), ...casesQueriesKeys.userActions, params],
  caseUserActionsStats: id => [...casesQueriesKeys.case(id), ...casesQueriesKeys.userActions, 'stats'],
  userProfiles: () => [...casesQueriesKeys.users, 'user-profiles'],
  userProfilesList: ids => [...casesQueriesKeys.userProfiles(), ids],
  currentUser: () => [...casesQueriesKeys.users, 'current-user'],
  suggestUsers: params => [...casesQueriesKeys.users, 'suggest', params],
  connectorTypes: () => [...casesQueriesKeys.connectors, 'types'],
  license: () => [...casesQueriesKeys.connectors, 'license'],
  tags: () => [...casesQueriesKeys.all, 'tags'],
  alertFeatureIds: alertRegistrationContexts => [...casesQueriesKeys.alerts, 'features', alertRegistrationContexts]
};
exports.casesQueriesKeys = casesQueriesKeys;
const casesMutationsKeys = {
  createCase: ['create-case'],
  deleteCases: ['delete-cases'],
  updateCases: ['update-cases'],
  deleteComment: ['delete-comment'],
  deleteFileAttachment: ['delete-file-attachment']
};
exports.casesMutationsKeys = casesMutationsKeys;