"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeItemFromSessionStorage = exports.isDeprecatedConnector = exports.getConnectorsFormValidators = exports.getConnectorIcon = exports.getConnectorById = exports.connectorDeprecationValidator = void 0;
var _api = require("../../common/api");
var _validator = require("./connectors/swimlane/validator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorById = (id, connectors) => {
  var _connectors$find;
  return (_connectors$find = connectors.find(c => c.id === id)) !== null && _connectors$find !== void 0 ? _connectors$find : null;
};
exports.getConnectorById = getConnectorById;
const validators = {
  [_api.ConnectorTypes.swimlane]: _validator.connectorValidator
};
const connectorDeprecationValidator = connector => {
  if (connector.isDeprecated) {
    return {
      message: 'Deprecated connector'
    };
  }
};
exports.connectorDeprecationValidator = connectorDeprecationValidator;
const getConnectorsFormValidators = ({
  connectors = [],
  config = {}
}) => ({
  ...config,
  validations: [{
    validator: ({
      value: connectorId
    }) => {
      const connector = getConnectorById(connectorId, connectors);
      if (connector != null) {
        return connectorDeprecationValidator(connector);
      }
    }
  }, {
    validator: ({
      value: connectorId
    }) => {
      const connector = getConnectorById(connectorId, connectors);
      if (connector != null) {
        var _validators$connector;
        return (_validators$connector = validators[connector.actionTypeId]) === null || _validators$connector === void 0 ? void 0 : _validators$connector.call(validators, connector);
      }
    }
  }]
});
exports.getConnectorsFormValidators = getConnectorsFormValidators;
const getConnectorIcon = (triggersActionsUi, type) => {
  /**
   * triggersActionsUi.actionTypeRegistry.get will throw an error if the type is not registered.
   * This will break Kibana if not handled properly.
   */
  const emptyResponse = '';
  if (type == null) {
    return emptyResponse;
  }
  try {
    if (triggersActionsUi.actionTypeRegistry.has(type)) {
      return triggersActionsUi.actionTypeRegistry.get(type).iconClass;
    }
  } catch {
    return emptyResponse;
  }
  return emptyResponse;
};
exports.getConnectorIcon = getConnectorIcon;
const isDeprecatedConnector = connector => {
  var _connector$isDeprecat;
  return (_connector$isDeprecat = connector === null || connector === void 0 ? void 0 : connector.isDeprecated) !== null && _connector$isDeprecat !== void 0 ? _connector$isDeprecat : false;
};
exports.isDeprecatedConnector = isDeprecatedConnector;
const removeItemFromSessionStorage = key => {
  window.sessionStorage.removeItem(key);
};
exports.removeItemFromSessionStorage = removeItemFromSessionStorage;