"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemovableUser = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _hoverable_user_with_avatar = require("./hoverable_user_with_avatar");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RemovableUserComponent = ({
  assignee,
  onRemoveAssignee
}) => {
  var _assignee$profile$use, _assignee$profile;
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isHovering, setIsHovering] = (0, _react.useState)(false);
  const removeAssigneeCallback = (0, _react.useCallback)(() => onRemoveAssignee(assignee.uid), [onRemoveAssignee, assignee.uid]);
  const onFocus = (0, _react.useCallback)(() => setIsHovering(true), []);
  const onFocusLeave = (0, _react.useCallback)(() => setIsHovering(false), []);
  const usernameDataTestSubj = (_assignee$profile$use = (_assignee$profile = assignee.profile) === null || _assignee$profile === void 0 ? void 0 : _assignee$profile.user.username) !== null && _assignee$profile$use !== void 0 ? _assignee$profile$use : assignee.uid;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    onMouseEnter: onFocus,
    onMouseLeave: onFocusLeave,
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "spaceBetween",
    "data-test-subj": `user-profile-assigned-user-group-${usernameDataTestSubj}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar.HoverableUserWithAvatar, {
    userInfo: assignee.profile
  })), permissions.update && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: i18n.REMOVE_ASSIGNEE,
    "data-test-subj": `user-profile-assigned-user-cross-tooltip-${usernameDataTestSubj}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    css: {
      opacity: isHovering ? 1 : 0
    },
    onFocus: onFocus,
    onBlur: onFocusLeave,
    "data-test-subj": `user-profile-assigned-user-cross-${usernameDataTestSubj}`,
    "aria-label": i18n.REMOVE_ASSIGNEE_ARIA_LABEL,
    iconType: "cross",
    color: "danger",
    iconSize: "m",
    onClick: removeAssigneeCallback
  }))));
};
RemovableUserComponent.displayName = 'RemovableUser';
const RemovableUser = /*#__PURE__*/_react.default.memo(RemovableUserComponent);
exports.RemovableUser = RemovableUser;