"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverableAvatarResolver = void 0;
var _react = _interopRequireDefault(require("react"));
var _user_converter = require("./user_converter");
var _hoverable_avatar = require("./hoverable_avatar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HoverableAvatarResolverComponent = ({
  user,
  userProfiles
}) => {
  var _convertToUserInfo;
  const {
    userInfo
  } = (_convertToUserInfo = (0, _user_converter.convertToUserInfo)(user, userProfiles)) !== null && _convertToUserInfo !== void 0 ? _convertToUserInfo : {
    userInfo: undefined
  };
  return /*#__PURE__*/_react.default.createElement(_hoverable_avatar.HoverableAvatar, {
    userInfo: userInfo
  });
};
HoverableAvatarResolverComponent.displayName = 'HoverableUserResolver';
const HoverableAvatarResolver = /*#__PURE__*/_react.default.memo(HoverableAvatarResolverComponent);
exports.HoverableAvatarResolver = HoverableAvatarResolver;