"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLastPage = void 0;
var _eui = require("@elastic/eui");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLastPage = ({
  userActivityQueryParams,
  userActionsStats
}) => {
  const lastPage = (0, _react.useMemo)(() => {
    if (!userActionsStats) {
      return 1;
    }
    const perPage = userActivityQueryParams.perPage;
    let lastPageType = 1;
    switch (userActivityQueryParams.type) {
      case 'action':
        lastPageType = Math.ceil(userActionsStats.totalOtherActions / perPage);
        break;
      case 'user':
        lastPageType = Math.ceil(userActionsStats.totalComments / perPage);
        break;
      case 'all':
        lastPageType = Math.ceil(userActionsStats.total / perPage);
        break;
      default:
        return (0, _eui.assertNever)(userActivityQueryParams.type);
    }
    return Math.max(lastPageType, 1);
  }, [userActionsStats, userActivityQueryParams]);
  return {
    lastPage
  };
};
exports.useLastPage = useLastPage;