"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSettingsUserActionBuilder = void 0;
var _common = require("./common");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSettingsLabel(userAction) {
  if (userAction.payload.settings.syncAlerts) {
    return `${_translations.ENABLED_SETTING} ${_translations.SYNC_ALERTS_LC}`;
  } else {
    return `${_translations.DISABLED_SETTING} ${_translations.SYNC_ALERTS_LC}`;
  }
}
const createSettingsUserActionBuilder = ({
  userAction,
  userProfiles,
  handleOutlineComment
}) => ({
  build: () => {
    var _action$payload, _action$payload$setti;
    const action = userAction;
    if ((action === null || action === void 0 ? void 0 : (_action$payload = action.payload) === null || _action$payload === void 0 ? void 0 : (_action$payload$setti = _action$payload.settings) === null || _action$payload$setti === void 0 ? void 0 : _action$payload$setti.syncAlerts) !== undefined) {
      const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
        userProfiles,
        userAction,
        handleOutlineComment,
        label: getSettingsLabel(action),
        icon: 'gear'
      });
      return commonBuilder.build();
    }

    // if new settings are introduced. they won't be rendered
    return [];
  }
});
exports.createSettingsUserActionBuilder = createSettingsUserActionBuilder;