"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUserActionTypeSupported = exports.getManualAlertIdsWithNoRuleId = void 0;
var _lodash = require("lodash");
var _api = require("../../../common/api");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isUserActionTypeSupported = type => _constants.SUPPORTED_ACTION_TYPES.includes(type);
exports.isUserActionTypeSupported = isUserActionTypeSupported;
const getManualAlertIdsWithNoRuleId = comments => {
  const dedupeAlerts = comments.reduce((alertIds, comment) => {
    if (comment.type === _api.CommentType.alert && (0, _lodash.isEmpty)(comment.rule.id)) {
      const ids = Array.isArray(comment.alertId) ? comment.alertId : [comment.alertId];
      ids.forEach(id => alertIds.add(id));
      return alertIds;
    }
    return alertIds;
  }, new Set());
  return Array.from(dedupeAlerts);
};
exports.getManualAlertIdsWithNoRuleId = getManualAlertIdsWithNoRuleId;