"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteAttachmentConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./property_actions/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteAttachmentConfirmationModalComponent = ({
  title,
  confirmButtonText,
  onConfirm,
  onCancel
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: title,
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: _translations.CANCEL_BUTTON,
    confirmButtonText: confirmButtonText,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    "data-test-subj": "property-actions-confirm-modal"
  });
};
DeleteAttachmentConfirmationModalComponent.displayName = 'DeleteAttachmentConfirmationModal';
const DeleteAttachmentConfirmationModal = /*#__PURE__*/_react.default.memo(DeleteAttachmentConfirmationModalComponent);
exports.DeleteAttachmentConfirmationModal = DeleteAttachmentConfirmationModal;