"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldAddComma = exports.shouldAddAnd = exports.createAssigneesUserActionBuilder = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _api = require("../../../common/api");
var _display_name = require("../user_profiles/display_name");
var _user_tooltip = require("../user_profiles/user_tooltip");
var _common = require("./common");
var i18n = _interopRequireWildcard(require("./translations"));
var _data_test_subject = require("../user_profiles/data_test_subject");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormatListItem = ({
  children,
  index,
  listSize
}) => {
  if (shouldAddAnd(index, listSize)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.AND, " ", children);
  } else if (shouldAddComma(index, listSize)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, ',');
  }
  return children;
};
FormatListItem.displayName = 'FormatListItem';
const shouldAddComma = (index, arrayLength) => {
  return arrayLength > 2 && index !== arrayLength - 1;
};
exports.shouldAddComma = shouldAddComma;
const shouldAddAnd = (index, arrayLength) => {
  return arrayLength > 1 && index === arrayLength - 1;
};
exports.shouldAddAnd = shouldAddAnd;
const Themselves = ({
  index,
  numOfAssigness
}) => /*#__PURE__*/_react.default.createElement(FormatListItem, {
  index: index,
  listSize: numOfAssigness
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.THEMSELVES));
Themselves.displayName = 'Themselves';
const AssigneeComponent = ({
  assignee,
  index,
  numOfAssigness
}) => {
  var _assignee$profile;
  return /*#__PURE__*/_react.default.createElement(FormatListItem, {
    index: index,
    listSize: numOfAssigness
  }, /*#__PURE__*/_react.default.createElement(_user_tooltip.UserToolTip, {
    userInfo: assignee.profile
  }, /*#__PURE__*/_react.default.createElement("strong", null, (0, _display_name.getName)((_assignee$profile = assignee.profile) === null || _assignee$profile === void 0 ? void 0 : _assignee$profile.user))));
};
AssigneeComponent.displayName = 'Assignee';
const AssigneesComponent = ({
  assignees,
  createdByUser
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, assignees.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "xs",
  wrap: true
}, assignees.map((assignee, index) => {
  const usernameDataTestSubj = (0, _data_test_subject.getUsernameDataTestSubj)(assignee);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `ua-assignee-${usernameDataTestSubj}`,
    grow: false,
    key: assignee.uid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textBreakWord"
  }, doesAssigneeMatchCreatedByUser(assignee, createdByUser) ? /*#__PURE__*/_react.default.createElement(Themselves, {
    index: index,
    numOfAssigness: assignees.length
  }) : /*#__PURE__*/_react.default.createElement(AssigneeComponent, {
    assignee: assignee,
    index: index,
    numOfAssigness: assignees.length
  })));
})));
AssigneesComponent.displayName = 'Assignees';
const Assignees = /*#__PURE__*/(0, _react.memo)(AssigneesComponent);
const doesAssigneeMatchCreatedByUser = (assignee, createdByUser) => {
  var _assignee$profile2;
  return assignee.uid === (createdByUser === null || createdByUser === void 0 ? void 0 : createdByUser.profileUid) ||
  // cases created before the assignees functionality will not have the profileUid so we'll need to fallback to the
  // next best field
  (assignee === null || assignee === void 0 ? void 0 : (_assignee$profile2 = assignee.profile) === null || _assignee$profile2 === void 0 ? void 0 : _assignee$profile2.user.username) === createdByUser.username;
};
const getLabelTitle = (userAction, userProfiles) => {
  const assignees = userAction.payload.assignees.map(assignee => {
    const profile = userProfiles === null || userProfiles === void 0 ? void 0 : userProfiles.get(assignee.uid);
    return {
      uid: assignee.uid,
      profile
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "xs",
    component: "span",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "ua-assignees-label",
    grow: false
  }, userAction.action === _api.Actions.add && i18n.ASSIGNED, userAction.action === _api.Actions.delete && i18n.UNASSIGNED), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Assignees, {
    createdByUser: userAction.createdBy,
    assignees: assignees
  })));
};
const createAssigneesUserActionBuilder = ({
  userAction,
  handleOutlineComment,
  userProfiles
}) => ({
  build: () => {
    const assigneesUserAction = userAction;
    const label = getLabelTitle(assigneesUserAction, userProfiles);
    const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
      userAction,
      userProfiles,
      handleOutlineComment,
      label,
      icon: 'userAvatar'
    });
    return commonBuilder.build();
  }
});
exports.createAssigneesUserActionBuilder = createAssigneesUserActionBuilder;