"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  PUSH_INCIDENT: true,
  UPDATE_INCIDENT: true,
  PUSH_LOCKED_TITLE: true,
  PUSH_LOCKED_DESC: true,
  CONFIGURE_CONNECTOR: true,
  PUSH_DISABLE_BY_KIBANA_CONFIG_TITLE: true,
  PUSH_DISABLE_BY_LICENSE_TITLE: true,
  LINK_CLOUD_DEPLOYMENT: true,
  LINK_ACTIONS_CONFIGURATION: true
};
exports.UPDATE_INCIDENT = exports.PUSH_LOCKED_TITLE = exports.PUSH_LOCKED_DESC = exports.PUSH_INCIDENT = exports.PUSH_DISABLE_BY_LICENSE_TITLE = exports.PUSH_DISABLE_BY_KIBANA_CONFIG_TITLE = exports.LINK_CLOUD_DEPLOYMENT = exports.LINK_ACTIONS_CONFIGURATION = exports.CONFIGURE_CONNECTOR = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PUSH_INCIDENT = thirdParty => {
  if (thirdParty === 'none') {
    return _i18n.i18n.translate('xpack.cases.caseView.pushThirdPartyIncident', {
      defaultMessage: 'Push as external incident'
    });
  }
  return _i18n.i18n.translate('xpack.cases.caseView.pushNamedIncident', {
    values: {
      thirdParty
    },
    defaultMessage: 'Push as { thirdParty } incident'
  });
};
exports.PUSH_INCIDENT = PUSH_INCIDENT;
const UPDATE_INCIDENT = thirdParty => {
  if (thirdParty === 'none') {
    return _i18n.i18n.translate('xpack.cases.caseView.updateThirdPartyIncident', {
      defaultMessage: 'Update external incident'
    });
  }
  return _i18n.i18n.translate('xpack.cases.caseView.updateNamedIncident', {
    values: {
      thirdParty
    },
    defaultMessage: 'Update { thirdParty } incident'
  });
};
exports.UPDATE_INCIDENT = UPDATE_INCIDENT;
const PUSH_LOCKED_TITLE = thirdParty => {
  if (thirdParty === 'none') {
    return _i18n.i18n.translate('xpack.cases.caseView.lockedIncidentTitleNone', {
      defaultMessage: 'External incident is up to date'
    });
  }
  return _i18n.i18n.translate('xpack.cases.caseView.lockedIncidentTitle', {
    values: {
      thirdParty
    },
    defaultMessage: '{ thirdParty } incident is up to date'
  });
};
exports.PUSH_LOCKED_TITLE = PUSH_LOCKED_TITLE;
const PUSH_LOCKED_DESC = _i18n.i18n.translate('xpack.cases.caseView.lockedIncidentDesc', {
  defaultMessage: 'No update is required'
});
exports.PUSH_LOCKED_DESC = PUSH_LOCKED_DESC;
const CONFIGURE_CONNECTOR = _i18n.i18n.translate('xpack.cases.caseView.pushToService.configureConnector', {
  defaultMessage: 'To create and update a case in an external system, select a connector.'
});
exports.CONFIGURE_CONNECTOR = CONFIGURE_CONNECTOR;
const PUSH_DISABLE_BY_KIBANA_CONFIG_TITLE = _i18n.i18n.translate('xpack.cases.caseView.pushToServiceDisableByConfigTitle', {
  defaultMessage: 'Enable external service in Kibana configuration file'
});
exports.PUSH_DISABLE_BY_KIBANA_CONFIG_TITLE = PUSH_DISABLE_BY_KIBANA_CONFIG_TITLE;
const PUSH_DISABLE_BY_LICENSE_TITLE = _i18n.i18n.translate('xpack.cases.caseView.pushToServiceDisableByLicenseTitle', {
  defaultMessage: 'Upgrade to an appropriate license'
});
exports.PUSH_DISABLE_BY_LICENSE_TITLE = PUSH_DISABLE_BY_LICENSE_TITLE;
const LINK_CLOUD_DEPLOYMENT = _i18n.i18n.translate('xpack.cases.caseView.cloudDeploymentLink', {
  defaultMessage: 'cloud deployment'
});
exports.LINK_CLOUD_DEPLOYMENT = LINK_CLOUD_DEPLOYMENT;
const LINK_ACTIONS_CONFIGURATION = _i18n.i18n.translate('xpack.cases.caseView.actionsConfigurationLink', {
  defaultMessage: 'Alerting and action settings in Kibana'
});
exports.LINK_ACTIONS_CONFIGURATION = LINK_ACTIONS_CONFIGURATION;