"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statuses = exports.allCaseStatus = void 0;
var _casesComponents = require("@kbn/cases-components");
var _types = require("../../../common/ui/types");
var _api = require("../../../common/api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusConfiguration = (0, _casesComponents.getStatusConfiguration)();
const allCaseStatus = {
  [_types.StatusAll]: {
    color: 'hollow',
    label: i18n.ALL
  }
};
exports.allCaseStatus = allCaseStatus;
const statuses = {
  [_api.CaseStatuses.open]: {
    ...statusConfiguration[_api.CaseStatuses.open],
    actions: {
      single: {
        title: i18n.OPEN_CASE
      }
    },
    actionBar: {
      title: i18n.CASE_OPENED
    },
    button: {
      label: i18n.REOPEN_CASE
    },
    stats: {
      title: i18n.OPEN_CASES
    }
  },
  [_api.CaseStatuses['in-progress']]: {
    ...statusConfiguration[_api.CaseStatuses['in-progress']],
    actions: {
      single: {
        title: i18n.MARK_CASE_IN_PROGRESS
      }
    },
    actionBar: {
      title: i18n.CASE_IN_PROGRESS
    },
    button: {
      label: i18n.MARK_CASE_IN_PROGRESS
    },
    stats: {
      title: i18n.IN_PROGRESS_CASES
    }
  },
  [_api.CaseStatuses.closed]: {
    ...statusConfiguration[_api.CaseStatuses.closed],
    actions: {
      single: {
        title: i18n.CLOSE_CASE
      }
    },
    actionBar: {
      title: i18n.CASE_CLOSED
    },
    button: {
      label: i18n.CLOSE_CASE
    },
    stats: {
      title: i18n.CLOSED_CASES
    }
  }
};
exports.statuses = statuses;