"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../links");
var _filters = require("./filters");
var _recent_cases = require("./recent_cases");
var _kibana = require("../../common/lib/kibana");
var _navigation = require("../../common/navigation");
var _query_client = require("../cases_context/query_client");
var _use_get_current_user_profile = require("../../containers/user_profiles/use_get_current_user_profile");
var _get_filter_options = require("./get_filter_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecentCases = /*#__PURE__*/_react.default.memo(props => {
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.casesQueryClient
  }, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  }), /*#__PURE__*/_react.default.createElement(RecentCasesWithoutQueryProvider, props));
});
exports.default = RecentCases;
RecentCases.displayName = 'RecentCases';

// eslint-disable-next-line import/no-default-export

const RecentCasesWithoutQueryProvider = /*#__PURE__*/_react.default.memo(({
  maxCasesToShow
}) => {
  const currentUser = (0, _kibana.useCurrentUser)();
  const {
    data: currentUserProfile,
    isLoading: isLoadingCurrentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const {
    getAllCasesUrl,
    navigateToAllCases
  } = (0, _navigation.useAllCasesNavigation)();
  const [recentCasesFilterBy, setRecentCasesFilterBy] = (0, _react.useState)('recentlyCreated');
  const navigateToAllCasesClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateToAllCases();
  }, [navigateToAllCases]);
  const recentCasesFilterOptions = (0, _react.useMemo)(() => {
    if (recentCasesFilterBy === 'myRecentlyAssigned') {
      return (0, _get_filter_options.getAssigneeFilter)({
        isLoadingCurrentUserProfile,
        currentUserProfile
      });
    }
    return (0, _get_filter_options.getReporterFilter)({
      currentUser,
      isLoadingCurrentUserProfile,
      recentCasesFilterBy,
      currentUserProfile
    });
  }, [currentUser, currentUserProfile, isLoadingCurrentUserProfile, recentCasesFilterBy]);

  // show the recently reported if we have the current user profile, or if we have the fallback user information
  const hasCurrentUserInfo = currentUserProfile != null || currentUser != null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, i18n.RECENT_CASES))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_filters.RecentCasesFilters, {
    filterBy: recentCasesFilterBy,
    setFilterBy: setRecentCasesFilterBy,
    hasCurrentUserInfo: hasCurrentUserInfo,
    isLoading: isLoadingCurrentUserProfile
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_recent_cases.RecentCasesComp, {
    filterOptions: recentCasesFilterOptions,
    maxCasesToShow: maxCasesToShow,
    recentCasesFilterBy: recentCasesFilterBy
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: navigateToAllCasesClick,
    href: getAllCasesUrl()
  }, ' ', i18n.VIEW_ALL_CASES))));
});
RecentCasesWithoutQueryProvider.displayName = 'RecentCases';
module.exports = exports.default;