"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconWithCount = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Icon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: 4px;
`;
const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-right: 16px;
`;
const OuterContainer = _styledComponents.default.span`
  width: fit-content;
`;
const IconWithCount = /*#__PURE__*/_react.default.memo(({
  count,
  icon,
  tooltip
}) => /*#__PURE__*/_react.default.createElement(OuterContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: tooltip
}, /*#__PURE__*/_react.default.createElement(FlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(Icon, {
  color: "default",
  size: "s",
  type: icon
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "default",
  size: "xs"
}, count))))));
exports.IconWithCount = IconWithCount;
IconWithCount.displayName = 'IconWithCount';