"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.caseFilterOptions = exports.RecentCasesFilters = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MY_RECENTLY_CREATED_ID = 'recentlyCreated';
const MY_RECENTLY_REPORTED_ID = 'myRecentlyReported';
const MY_RECENTLY_ASSIGNED_ID = 'myRecentlyAssigned';
const caseFilterOptions = [{
  id: MY_RECENTLY_CREATED_ID,
  label: i18n.RECENTLY_CREATED_CASES
}, {
  id: MY_RECENTLY_REPORTED_ID,
  label: i18n.MY_RECENTLY_REPORTED_CASES
}, {
  id: MY_RECENTLY_ASSIGNED_ID,
  label: i18n.MY_RECENTLY_ASSIGNED_CASES
}];
exports.caseFilterOptions = caseFilterOptions;
const RecentCasesFilters = /*#__PURE__*/_react.default.memo(({
  filterBy,
  setFilterBy,
  hasCurrentUserInfo,
  isLoading = false
}) => {
  const options = caseFilterOptions.map(option => {
    return {
      value: option.id,
      text: option.label
    };
  });
  const onChange = (0, _react.useCallback)(e => {
    setFilterBy(e.target.value);
  }, [setFilterBy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "recent-cases-filter",
    disabled: !hasCurrentUserInfo,
    fullWidth: true,
    hasNoInitialSelection: true,
    isLoading: isLoading,
    onChange: onChange,
    options: options,
    value: filterBy
  });
});
exports.RecentCasesFilters = RecentCasesFilters;
RecentCasesFilters.displayName = 'RecentCasesFilters';