"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensOpenVisualization = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../client/attachment_framework/types");
var _kibana = require("../../../../common/lib/kibana");
var _utils = require("../../../../../common/utils/markdown_plugins/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLensOpenVisualization = ({
  comment
}) => {
  var _parsedComment$childr;
  const parsedComment = (0, _utils.parseCommentString)(comment);
  const lensVisualization = (0, _utils.getLensVisualizations)((_parsedComment$childr = parsedComment === null || parsedComment === void 0 ? void 0 : parsedComment.children) !== null && _parsedComment$childr !== void 0 ? _parsedComment$childr : []);
  const {
    lens: {
      navigateToPrefilledEditor,
      canUseEditor
    }
  } = (0, _kibana.useKibana)().services;
  const handleClick = (0, _react.useCallback)(() => {
    navigateToPrefilledEditor({
      id: '',
      timeRange: lensVisualization[0].timeRange,
      attributes: lensVisualization[0].attributes
    }, {
      openInNewTab: true
    });
  }, [lensVisualization, navigateToPrefilledEditor]);
  return {
    canUseEditor: canUseEditor(),
    actionConfig: !lensVisualization.length ? null : {
      type: _types.AttachmentActionType.BUTTON,
      iconType: 'lensApp',
      label: _i18n.i18n.translate('xpack.cases.markdownEditor.plugins.lens.openVisualizationButtonLabel', {
        defaultMessage: 'Open visualization'
      }),
      onClick: handleClick
    }
  };
};
exports.useLensOpenVisualization = useLensOpenVisualization;