"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensMarkDownRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/kibana-react-plugin/common");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styledComponents.default.div`
  min-height: ${_constants.LENS_VISUALIZATION_HEIGHT}px;
`;

// when displaying chart in modal the tooltip is render under the modal
const LensChartTooltipFix = (0, _common.createGlobalStyle)`
  div.euiOverlayMask[data-relative-to-header=above] ~ [id^='echTooltipPortal'] {
    z-index: ${({
  theme
}) => theme.eui.euiZLevel7} !important;
  }
`;
const LensMarkDownRendererComponent = ({
  attributes,
  timeRange
}) => {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _kibana.useKibana)().services;
  if (!attributes) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: "",
    style: {
      height: _constants.LENS_VISUALIZATION_HEIGHT
    },
    timeRange: timeRange,
    attributes: attributes,
    renderMode: "view",
    disableTriggers: true,
    executionContext: {
      type: 'cases'
    },
    syncTooltips: false,
    syncCursor: false
  }), /*#__PURE__*/_react.default.createElement(LensChartTooltipFix, null));
};
LensMarkDownRendererComponent.displayName = 'LensMarkDownRenderer';
const LensMarkDownRenderer = /*#__PURE__*/_react.default.memo(LensMarkDownRendererComponent);
exports.LensMarkDownRenderer = LensMarkDownRenderer;