"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownEditorForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var i18n = _interopRequireWildcard(require("../../common/translations"));
var _editor = require("./editor");
var _context = require("./context");
var _use_markdown_session_storage = require("./use_markdown_session_storage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BottomContentWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => `
    padding: ${theme.eui.euiSizeM} 0;
  `}
`;
const MarkdownEditorForm = /*#__PURE__*/_react.default.memo( /*#__PURE__*/(0, _react.forwardRef)(({
  id,
  field,
  dataTestSubj,
  idAria,
  bottomRightContent,
  caseTitle,
  caseTags,
  draftStorageKey,
  disabledUiPlugins,
  initialValue
}, ref) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const {
    hasConflicts
  } = (0, _use_markdown_session_storage.useMarkdownSessionStorage)({
    field,
    sessionKey: draftStorageKey,
    initialValue
  });
  const conflictWarningText = i18n.VERSION_CONFLICT_WARNING(id === 'description' ? id : 'comment');
  const commentEditorContextValue = (0, _react.useMemo)(() => ({
    editorId: id,
    value: field.value,
    caseTitle,
    caseTags
  }), [id, field.value, caseTitle, caseTags]);
  return /*#__PURE__*/_react.default.createElement(_context.CommentEditorContext.Provider, {
    value: commentEditorContextValue
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    fullWidth: true,
    error: errorMessage,
    helpText: field.helpText,
    isInvalid: isInvalid,
    label: field.label,
    labelAppend: field.labelAppend
  }, /*#__PURE__*/_react.default.createElement(_editor.MarkdownEditor, {
    ref: ref,
    ariaLabel: idAria,
    editorId: id,
    onChange: field.setValue,
    value: field.value,
    disabledUiPlugins: disabledUiPlugins,
    "data-test-subj": `${dataTestSubj}-markdown-editor`
  })), bottomRightContent && /*#__PURE__*/_react.default.createElement(BottomContentWrapper, {
    justifyContent: 'flexEnd'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s"
  }, hasConflicts && conflictWarningText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), bottomRightContent)));
}));
exports.MarkdownEditorForm = MarkdownEditorForm;
MarkdownEditorForm.displayName = 'MarkdownEditorForm';