"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkButton = exports.LinkAnchor = exports.ConfigureCaseButton = exports.CaseDetailsLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _navigation = require("../../common/navigation");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkButton =
// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, props, children);

// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
exports.LinkButton = LinkButton;
const LinkAnchor = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, props, children);
exports.LinkAnchor = LinkAnchor;
// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
const CaseDetailsLinkComponent = ({
  children,
  detailName,
  title
}) => {
  const {
    getCaseViewUrl,
    navigateToCaseView
  } = (0, _navigation.useCaseViewNavigation)();
  const navigateToCaseViewClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToCaseView({
      detailName
    });
  }, [navigateToCaseView, detailName]);
  return /*#__PURE__*/_react.default.createElement(LinkAnchor, {
    onClick: navigateToCaseViewClick,
    href: getCaseViewUrl({
      detailName
    }),
    "data-test-subj": "case-details-link",
    "aria-label": i18n.CASE_DETAILS_LINK_ARIA(title !== null && title !== void 0 ? title : detailName)
  }, children ? children : detailName);
};
const CaseDetailsLink = /*#__PURE__*/_react.default.memo(CaseDetailsLinkComponent);
exports.CaseDetailsLink = CaseDetailsLink;
CaseDetailsLink.displayName = 'CaseDetailsLink';
// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
const ConfigureCaseButtonComponent = ({
  isDisabled,
  label,
  msgTooltip,
  showToolTip,
  titleTooltip
}) => {
  const {
    getConfigureCasesUrl,
    navigateToConfigureCases
  } = (0, _navigation.useConfigureCasesNavigation)();
  const navigateToConfigureCasesClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    navigateToConfigureCases();
  }, [navigateToConfigureCases]);
  const configureCaseButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(LinkButton, {
    onClick: navigateToConfigureCasesClick,
    href: getConfigureCasesUrl(),
    iconType: "controlsHorizontal",
    isDisabled: isDisabled,
    "aria-label": label,
    "data-test-subj": "configure-case-button"
  }, label), [label, isDisabled, navigateToConfigureCasesClick, getConfigureCasesUrl]);
  return showToolTip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    title: titleTooltip,
    content: /*#__PURE__*/_react.default.createElement("p", null, msgTooltip),
    "data-test-subj": "configure-case-tooltip"
  }, configureCaseButton) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, configureCaseButton);
};
const ConfigureCaseButton = /*#__PURE__*/_react.default.memo(ConfigureCaseButtonComponent);
exports.ConfigureCaseButton = ConfigureCaseButton;
ConfigureCaseButton.displayName = 'ConfigureCaseButton';