"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsertTimeline = void 0;
var _react = require("react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _use_timeline_context = require("../timeline_context/use_timeline_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InsertTimeline = ({
  fieldName
}) => {
  var _useTimelineContext, _formData$fieldName;
  const {
    setFieldValue,
    getFormData
  } = (0, _hook_form_lib.useFormContext)();
  const timelineHooks = (_useTimelineContext = (0, _use_timeline_context.useTimelineContext)()) === null || _useTimelineContext === void 0 ? void 0 : _useTimelineContext.hooks;
  const formData = getFormData();
  const onTimelineAttached = (0, _react.useCallback)(newValue => setFieldValue(fieldName, newValue), [fieldName, setFieldValue]);
  timelineHooks === null || timelineHooks === void 0 ? void 0 : timelineHooks.useInsertTimeline((_formData$fieldName = formData[fieldName]) !== null && _formData$fieldName !== void 0 ? _formData$fieldName : '', onTimelineAttached);
  return null;
};
exports.InsertTimeline = InsertTimeline;