"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterPopoverComponent = exports.FilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScrollableDiv = _styledComponents.default.div`
  max-height: 250px;
  overflow: auto;
`;
const toggleSelectedGroup = (group, selectedGroups) => {
  const selectedGroupIndex = selectedGroups.indexOf(group);
  if (selectedGroupIndex >= 0) {
    return [...selectedGroups.slice(0, selectedGroupIndex), ...selectedGroups.slice(selectedGroupIndex + 1)];
  }
  return [...selectedGroups, group];
};

/**
 * Popover for selecting a field to filter on
 *
 * @param buttonLabel label on dropdwon button
 * @param onSelectedOptionsChanged change listener to be notified when option selection changes
 * @param options to display for filtering
 * @param optionsEmptyLabel shows when options empty
 * @param selectedOptions manage state of selectedOptions
 */
const FilterPopoverComponent = ({
  buttonLabel,
  onSelectedOptionsChanged,
  options,
  optionsEmptyLabel,
  selectedOptions
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const setIsPopoverOpenCb = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const toggleSelectedGroupCb = (0, _react.useCallback)(option => onSelectedOptionsChanged(toggleSelectedGroup(option, selectedOptions)), [selectedOptions, onSelectedOptionsChanged]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": `options-filter-popover-button-${buttonLabel}`,
      iconType: "arrowDown",
      onClick: setIsPopoverOpenCb,
      isSelected: isPopoverOpen,
      numFilters: options.length,
      hasActiveFilters: selectedOptions.length > 0,
      numActiveFilters: selectedOptions.length,
      "aria-label": buttonLabel
    }, buttonLabel),
    isOpen: isPopoverOpen,
    closePopover: setIsPopoverOpenCb,
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(ScrollableDiv, null, options.map((option, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: selectedOptions.includes(option) ? 'on' : undefined,
    "data-test-subj": `options-filter-popover-item-${option}`,
    key: `${index}-${option}`,
    onClick: toggleSelectedGroupCb.bind(null, option)
  }, option))), options.length === 0 && optionsEmptyLabel != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, optionsEmptyLabel)))));
};
exports.FilterPopoverComponent = FilterPopoverComponent;
FilterPopoverComponent.displayName = 'FilterPopoverComponent';
const FilterPopover = /*#__PURE__*/_react.default.memo(FilterPopoverComponent);
exports.FilterPopover = FilterPopover;
FilterPopover.displayName = 'FilterPopover';