"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseMimeType = exports.isValidFileExternalReferenceMetadata = exports.isImage = void 0;
var _mime_types = require("../../../common/constants/mime_types");
var _api = require("../../../common/api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isImage = file => {
  var _file$mimeType;
  return (_file$mimeType = file.mimeType) === null || _file$mimeType === void 0 ? void 0 : _file$mimeType.startsWith('image/');
};
exports.isImage = isImage;
const parseMimeType = mimeType => {
  if (typeof mimeType === 'undefined') {
    return i18n.UNKNOWN_MIME_TYPE;
  }
  if (_mime_types.imageMimeTypes.includes(mimeType)) {
    return i18n.IMAGE_MIME_TYPE;
  }
  if (_mime_types.textMimeTypes.includes(mimeType)) {
    return i18n.TEXT_MIME_TYPE;
  }
  if (_mime_types.compressionMimeTypes.includes(mimeType)) {
    return i18n.COMPRESSED_MIME_TYPE;
  }
  if (_mime_types.pdfMimeTypes.includes(mimeType)) {
    return i18n.PDF_MIME_TYPE;
  }
  const result = mimeType.split('/');
  if (result.length <= 1 || result[0] === '') {
    return i18n.UNKNOWN_MIME_TYPE;
  }
  return result[0].charAt(0).toUpperCase() + result[0].slice(1);
};
exports.parseMimeType = parseMimeType;
const isValidFileExternalReferenceMetadata = externalReferenceMetadata => {
  var _externalReferenceMet;
  return _api.FileAttachmentMetadataRt.is(externalReferenceMetadata) && (externalReferenceMetadata === null || externalReferenceMetadata === void 0 ? void 0 : (_externalReferenceMet = externalReferenceMetadata.files) === null || _externalReferenceMet === void 0 ? void 0 : _externalReferenceMet.length) >= 1;
};
exports.isValidFileExternalReferenceMetadata = isValidFileExternalReferenceMetadata;