"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFileType = void 0;
var _react = _interopRequireDefault(require("react"));
var _types = require("../../client/attachment_framework/types");
var _api = require("../../../common/api");
var _file_download_button = require("./file_download_button");
var _file_name_link = require("./file_name_link");
var _file_preview = require("./file_preview");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
var _use_file_preview = require("./use_file_preview");
var _file_delete_button = require("./file_delete_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileAttachmentEvent = ({
  file
}) => {
  const {
    isPreviewVisible,
    showPreview,
    closePreview
  } = (0, _use_file_preview.useFilePreview)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ADDED, /*#__PURE__*/_react.default.createElement(_file_name_link.FileNameLink, {
    file: file,
    showPreview: showPreview
  }), isPreviewVisible && /*#__PURE__*/_react.default.createElement(_file_preview.FilePreview, {
    closePreview: closePreview,
    selectedFile: file
  }));
};
FileAttachmentEvent.displayName = 'FileAttachmentEvent';
function getFileDownloadButton(fileId) {
  return /*#__PURE__*/_react.default.createElement(_file_download_button.FileDownloadButton, {
    fileId: fileId,
    isIcon: false
  });
}
function getFileDeleteButton(caseId, fileId) {
  return /*#__PURE__*/_react.default.createElement(_file_delete_button.FileDeleteButton, {
    caseId: caseId,
    fileId: fileId,
    isIcon: false
  });
}
const getFileAttachmentActions = ({
  caseId,
  fileId
}) => [{
  type: _types.AttachmentActionType.CUSTOM,
  render: () => getFileDownloadButton(fileId),
  label: i18n.DOWNLOAD_FILE,
  isPrimary: false
}, {
  type: _types.AttachmentActionType.CUSTOM,
  render: () => getFileDeleteButton(caseId, fileId),
  label: i18n.DELETE_FILE,
  isPrimary: false
}];
const getFileAttachmentViewObject = props => {
  const caseId = props.caseData.id;
  const fileId = props.externalReferenceId;
  if (!(0, _utils.isValidFileExternalReferenceMetadata)(props.externalReferenceMetadata)) {
    return {
      type: 'regular',
      event: i18n.ADDED_UNKNOWN_FILE,
      timelineAvatar: 'document',
      getActions: () => [{
        type: _types.AttachmentActionType.CUSTOM,
        render: () => getFileDeleteButton(caseId, fileId),
        label: i18n.DELETE_FILE,
        isPrimary: false
      }],
      hideDefaultActions: true
    };
  }
  const fileMetadata = props.externalReferenceMetadata.files[0];
  const file = {
    id: fileId,
    ...fileMetadata
  };
  return {
    event: /*#__PURE__*/_react.default.createElement(FileAttachmentEvent, {
      file: file
    }),
    timelineAvatar: (0, _utils.isImage)(file) ? 'image' : 'document',
    getActions: () => getFileAttachmentActions({
      caseId,
      fileId
    }),
    hideDefaultActions: true
  };
};
const getFileType = () => ({
  id: _api.FILE_ATTACHMENT_TYPE,
  icon: 'document',
  displayName: 'File Attachment Type',
  getAttachmentViewObject: getFileAttachmentViewObject,
  getAttachmentRemovalObject: () => ({
    event: i18n.REMOVED_FILE
  })
});
exports.getFileType = getFileType;