"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileNameLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileNameLinkComponent = ({
  file,
  showPreview
}) => {
  let fileName = file.name;
  if (typeof file.extension !== 'undefined') {
    fileName += `.${file.extension}`;
  }
  if ((0, _utils.isImage)(file)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: showPreview,
      "data-test-subj": "cases-files-name-link"
    }, fileName);
  } else {
    return /*#__PURE__*/_react.default.createElement("span", {
      title: i18n.NO_PREVIEW,
      "data-test-subj": "cases-files-name-text"
    }, fileName);
  }
};
FileNameLinkComponent.displayName = 'FileNameLink';
const FileNameLink = /*#__PURE__*/_react.default.memo(FileNameLinkComponent);
exports.FileNameLink = FileNameLink;