"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PushButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PushButtonComponent = ({
  disabled,
  errorsMsg,
  isLoading,
  hasBeenPushed,
  connectorName,
  showTooltip,
  pushToService
}) => {
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "push-to-external-service",
    iconType: "importAction",
    onClick: pushToService,
    disabled: disabled,
    isLoading: isLoading
  }, hasBeenPushed ? i18n.UPDATE_INCIDENT(connectorName) : i18n.PUSH_INCIDENT(connectorName));
  return showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    title: errorsMsg.length > 0 ? errorsMsg[0].title : i18n.PUSH_LOCKED_TITLE(connectorName),
    content: /*#__PURE__*/_react.default.createElement("p", null, errorsMsg.length > 0 ? errorsMsg[0].description : i18n.PUSH_LOCKED_DESC),
    "data-test-subj": "push-button-tooltip"
  }, button) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, button);
};
PushButtonComponent.displayName = 'PushButton';
const PushButton = /*#__PURE__*/_react.default.memo(PushButtonComponent);
exports.PushButton = PushButton;