"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _api = require("../../../common/api");
var _form = require("../connector_selector/form");
var _fields_form = require("../connectors/fields_form");
var _schema = require("./schema");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("../utils");
var _use_push_to_service = require("../use_push_to_service");
var _kibana = require("../../common/lib/kibana");
var _push_button = require("./push_button");
var _push_callouts = require("./push_callouts");
var _utils2 = require("../configure_cases/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable complexity */

const editConnectorReducer = (state, action) => {
  switch (action.type) {
    case 'SET_CURRENT_CONNECTOR':
      return {
        ...state,
        currentConnector: action.payload
      };
    case 'SET_FIELDS':
      return {
        ...state,
        fields: action.payload
      };
    case 'SET_EDIT_CONNECTOR':
      return {
        ...state,
        editConnector: action.payload
      };
    default:
      return state;
  }
};
const initialState = {
  currentConnector: null,
  fields: null,
  editConnector: false
};
const EditConnector = /*#__PURE__*/_react.default.memo(({
  caseData,
  caseConnectors,
  supportedActionConnectors,
  isLoading,
  onSubmit
}) => {
  var _actionConnector$name;
  const caseFields = caseData.connector.fields;
  const selectedConnector = caseData.connector.id;
  const actionConnector = (0, _utils.getConnectorById)(caseData.connector.id, supportedActionConnectors);
  const isValidConnector = !!actionConnector;
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      connectorId: selectedConnector
    },
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema
  });
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  const actionsReadCapabilities = actions.read;
  const {
    setFieldValue,
    submit
  } = form;
  const [{
    currentConnector,
    fields,
    editConnector
  }, dispatch] = (0, _react.useReducer)(editConnectorReducer, {
    ...initialState,
    fields: caseFields,
    currentConnector: actionConnector
  });

  /**
   *  only enable the save button if changes were made to the previous selected
   * connector or its fields
   * null and none are equivalent to `no connector`.
   * This makes sure we don't enable the button when the "no connector" option is selected
   * by default. e.g. when a case is created without a connector
   */
  const isDefaultNoneConnectorSelected = currentConnector === null && selectedConnector === _api.NONE_CONNECTOR_ID;
  const enableSave = !isDefaultNoneConnectorSelected && (currentConnector === null || currentConnector === void 0 ? void 0 : currentConnector.id) !== selectedConnector || !(0, _fastDeepEqual.default)(fields, caseFields);
  const onChangeConnector = (0, _react.useCallback)(newConnectorId => {
    // change connector on dropdown action
    if ((currentConnector === null || currentConnector === void 0 ? void 0 : currentConnector.id) !== newConnectorId) {
      var _caseConnectors$newCo, _caseConnectors$newCo2;
      dispatch({
        type: 'SET_CURRENT_CONNECTOR',
        payload: (0, _utils.getConnectorById)(newConnectorId, supportedActionConnectors)
      });
      dispatch({
        type: 'SET_FIELDS',
        payload: (_caseConnectors$newCo = (_caseConnectors$newCo2 = caseConnectors[newConnectorId]) === null || _caseConnectors$newCo2 === void 0 ? void 0 : _caseConnectors$newCo2.fields) !== null && _caseConnectors$newCo !== void 0 ? _caseConnectors$newCo : null
      });
    }
  }, [currentConnector, caseConnectors, supportedActionConnectors]);
  const onFieldsChange = (0, _react.useCallback)(newFields => {
    if (!(0, _fastDeepEqual.default)(newFields, fields)) {
      dispatch({
        type: 'SET_FIELDS',
        payload: newFields
      });
    }
  }, [fields, dispatch]);
  const resetConnector = (0, _react.useCallback)(() => {
    setFieldValue('connectorId', selectedConnector);
    dispatch({
      type: 'SET_CURRENT_CONNECTOR',
      payload: actionConnector
    });
    dispatch({
      type: 'SET_FIELDS',
      payload: caseFields
    });
    dispatch({
      type: 'SET_EDIT_CONNECTOR',
      payload: false
    });
  }, [actionConnector, caseFields, selectedConnector, setFieldValue]);
  const onError = (0, _react.useCallback)(() => {
    resetConnector();
  }, [resetConnector]);
  const onCancelConnector = (0, _react.useCallback)(() => {
    resetConnector();
  }, [resetConnector]);
  const onSubmitConnector = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data: newData
    } = await submit();
    if (isValid && newData.connectorId) {
      const connector = (0, _utils.getConnectorById)(newData.connectorId, supportedActionConnectors);
      const connectorToUpdate = connector ? (0, _utils2.normalizeActionConnector)(connector) : (0, _utils2.getNoneConnector)();
      const connectorWithFields = {
        ...connectorToUpdate,
        fields
      };
      onSubmit(connectorWithFields, onError, _fp.noop);
      dispatch({
        type: 'SET_EDIT_CONNECTOR',
        payload: false
      });
    }
  }, [submit, supportedActionConnectors, fields, onSubmit, onError]);
  const onEditClick = (0, _react.useCallback)(() => {
    dispatch({
      type: 'SET_EDIT_CONNECTOR',
      payload: true
    });
  }, [dispatch]);
  const connectorIdConfig = (0, _utils.getConnectorsFormValidators)({
    config: _schema.schema.connectorId,
    connectors: supportedActionConnectors
  });
  const connectorWithName = {
    ...caseData.connector,
    name: (0, _fp.isEmpty)(actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.name) ? caseData.connector.name : (_actionConnector$name = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.name) !== null && _actionConnector$name !== void 0 ? _actionConnector$name : ''
  };
  const {
    errorsMsg,
    needsToBePushed,
    hasBeenPushed,
    isLoading: isLoadingPushToService,
    hasPushPermissions,
    hasErrorMessages,
    hasLicenseError,
    handlePushToService
  } = (0, _use_push_to_service.usePushToService)({
    connector: connectorWithName,
    caseConnectors,
    caseId: caseData.id,
    caseStatus: caseData.status,
    isValidConnector
  });
  const disablePushButton = isLoadingPushToService || errorsMsg.length > 0 || !hasPushPermissions || !isValidConnector || !needsToBePushed;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    justifyContent: "spaceBetween",
    responsive: false,
    "data-test-subj": "case-view-edit-connector"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "connector-edit-header"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.CONNECTORS)), !isLoading && !editConnector && hasPushPermissions && actionsReadCapabilities ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "connector-edit",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "connector-edit-button",
    "aria-label": i18n.EDIT_CONNECTOR_ARIA,
    iconType: "pencil",
    onClick: onEditClick
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "edit-connectors",
    direction: "column",
    alignItems: "stretch"
  }, !isLoading && !editConnector && hasErrorMessages && actionsReadCapabilities && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "push-callouts"
  }, /*#__PURE__*/_react.default.createElement(_push_callouts.PushCallouts, {
    errorsMsg: errorsMsg,
    hasLicenseError: hasLicenseError,
    hasConnectors: supportedActionConnectors.length > 0,
    onEditClick: onEditClick
  })), /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "connectorId",
    config: connectorIdConfig,
    component: _form.ConnectorSelector,
    componentProps: {
      connectors: supportedActionConnectors,
      dataTestSubj: 'caseConnectors',
      defaultValue: selectedConnector,
      disabled: !hasPushPermissions,
      idAria: 'caseConnectors',
      isEdit: editConnector,
      isLoading
    },
    onChange: onChangeConnector
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "edit-connector-fields-form-flex-item"
  }, !editConnector && !actionsReadCapabilities && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "edit-connector-permissions-error-msg",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.READ_ACTIONS_PERMISSIONS_ERROR_MSG)), /*#__PURE__*/_react.default.createElement(_fields_form.ConnectorFieldsForm, {
    connector: currentConnector,
    fields: fields,
    isEdit: editConnector,
    onChange: onFieldsChange
  })), editConnector && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !enableSave,
    color: "success",
    "data-test-subj": "edit-connectors-submit",
    fill: true,
    iconType: "save",
    onClick: onSubmitConnector,
    size: "s"
  }, i18n.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "edit-connectors-cancel",
    iconType: "cross",
    onClick: onCancelConnector,
    size: "s"
  }, i18n.CANCEL)))), !hasErrorMessages && !isLoading && !editConnector && hasPushPermissions && actionsReadCapabilities && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_push_button.PushButton, {
    hasBeenPushed: hasBeenPushed,
    disabled: disablePushButton,
    isLoading: isLoadingPushToService,
    pushToService: handlePushToService,
    errorsMsg: errorsMsg,
    showTooltip: errorsMsg.length > 0 || !needsToBePushed || !hasPushPermissions,
    connectorName: connectorWithName.name
  }))))));
});
exports.EditConnector = EditConnector;
EditConnector.displayName = 'EditConnector';