"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Connector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _form = require("../connector_selector/form");
var _fields_form = require("../connectors/fields_form");
var _schema = require("./schema");
var _use_configure = require("../../containers/configure/use_configure");
var _utils = require("../utils");
var _kibana = require("../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("../../common/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorFields = ({
  connectors,
  isEdit,
  field,
  setErrors
}) => {
  var _getConnectorById;
  const [{
    connectorId
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['connectorId']
  });
  const {
    setValue
  } = field;
  const connector = (_getConnectorById = (0, _utils.getConnectorById)(connectorId, connectors)) !== null && _getConnectorById !== void 0 ? _getConnectorById : null;
  return /*#__PURE__*/_react.default.createElement(_fields_form.ConnectorFieldsForm, {
    connector: connector,
    fields: field.value,
    isEdit: isEdit,
    onChange: setValue
  });
};
ConnectorFields.displayName = 'ConnectorFields';
const ConnectorComponent = ({
  connectors,
  isLoading,
  isLoadingConnectors
}) => {
  const {
    getFields,
    setFieldValue
  } = (0, _hook_form_lib.useFormContext)();
  const {
    connector: configurationConnector
  } = (0, _use_configure.useCaseConfigure)();
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  const handleConnectorChange = (0, _react.useCallback)(() => {
    const {
      fields
    } = getFields();
    fields.setValue(null);
  }, [getFields]);
  const defaultConnectorId = (0, _react.useMemo)(() => {
    return connectors.some(connector => connector.id === configurationConnector.id) ? configurationConnector.id : 'none';
  }, [configurationConnector.id, connectors]);
  (0, _react.useEffect)(() => setFieldValue('connectorId', defaultConnectorId), [defaultConnectorId, setFieldValue]);
  const connectorIdConfig = (0, _utils.getConnectorsFormValidators)({
    config: _schema.schema.connectorId,
    connectors
  });
  if (!actions.read) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "create-case-connector-permissions-error-msg",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("span", null, i18n.READ_ACTIONS_PERMISSIONS_ERROR_MSG));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "connectorId",
    config: connectorIdConfig,
    component: _form.ConnectorSelector,
    defaultValue: defaultConnectorId,
    componentProps: {
      connectors,
      handleChange: handleConnectorChange,
      dataTestSubj: 'caseConnectors',
      disabled: isLoading || isLoadingConnectors,
      idAria: 'caseConnectors',
      isLoading: isLoading || isLoadingConnectors
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields",
    component: ConnectorFields,
    componentProps: {
      connectors,
      isEdit: true
    }
  })));
};
ConnectorComponent.displayName = 'ConnectorComponent';
const Connector = /*#__PURE__*/(0, _react.memo)(ConnectorComponent);
exports.Connector = Connector;