"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _api = require("../../../../common/api");
var _kibana = require("../../../common/lib/kibana");
var _card = require("../card");
var _use_get_choices = require("./use_get_choices");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _deprecated_callout = require("../deprecated_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetChoicesFields = ['category', 'subcategory', 'priority'];
const defaultFields = {
  category: [],
  subcategory: [],
  priority: []
};
const ServiceNowSIRFieldsComponent = ({
  isEdit = true,
  fields,
  connector,
  onChange
}) => {
  const init = (0, _react.useRef)(true);
  const {
    category = null,
    destIp = true,
    malwareHash = true,
    malwareUrl = true,
    priority = null,
    sourceIp = true,
    subcategory = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http,
    notifications
  } = (0, _kibana.useKibana)().services;
  const [choices, setChoices] = (0, _react.useState)(defaultFields);
  const showConnectorWarning = connector.isDeprecated;
  const onChangeCb = (0, _react.useCallback)((key, value) => {
    onChange({
      ...fields,
      [key]: value
    });
  }, [fields, onChange]);
  const onChoicesSuccess = values => {
    setChoices(values.reduce((acc, value) => ({
      ...acc,
      [value.element]: [...(acc[value.element] != null ? acc[value.element] : []), value]
    }), defaultFields));
  };
  const {
    isLoading: isLoadingChoices
  } = (0, _use_get_choices.useGetChoices)({
    http,
    toastNotifications: notifications.toasts,
    connector,
    fields: useGetChoicesFields,
    onSuccess: onChoicesSuccess
  });
  const categoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.category), [choices.category]);
  const priorityOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.priority), [choices.priority]);
  const subcategoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.subcategory.filter(choice => choice.dependent_value === category)), [choices.subcategory, category]);
  const listItems = (0, _react.useMemo)(() => {
    var _priorityOptions$find, _categoryOptions$find, _subcategoryOptions$f;
    return [...(destIp != null && destIp ? [{
      title: i18n.DEST_IP,
      description: i18n.ALERT_FIELD_ENABLED_TEXT
    }] : []), ...(sourceIp != null && sourceIp ? [{
      title: i18n.SOURCE_IP,
      description: i18n.ALERT_FIELD_ENABLED_TEXT
    }] : []), ...(malwareUrl != null && malwareUrl ? [{
      title: i18n.MALWARE_URL,
      description: i18n.ALERT_FIELD_ENABLED_TEXT
    }] : []), ...(malwareHash != null && malwareHash ? [{
      title: i18n.MALWARE_HASH,
      description: i18n.ALERT_FIELD_ENABLED_TEXT
    }] : []), ...(priority != null && priority.length > 0 ? [{
      title: i18n.PRIORITY,
      description: (_priorityOptions$find = priorityOptions.find(option => `${option.value}` === priority)) === null || _priorityOptions$find === void 0 ? void 0 : _priorityOptions$find.text
    }] : []), ...(category != null && category.length > 0 ? [{
      title: i18n.CATEGORY,
      description: (_categoryOptions$find = categoryOptions.find(option => `${option.value}` === category)) === null || _categoryOptions$find === void 0 ? void 0 : _categoryOptions$find.text
    }] : []), ...(subcategory != null && subcategory.length > 0 ? [{
      title: i18n.SUBCATEGORY,
      description: (_subcategoryOptions$f = subcategoryOptions.find(option => `${option.value}` === subcategory)) === null || _subcategoryOptions$f === void 0 ? void 0 : _subcategoryOptions$f.text
    }] : [])];
  }, [category, categoryOptions, destIp, malwareHash, malwareUrl, priority, priorityOptions, sourceIp, subcategory, subcategoryOptions]);

  // Set field at initialization
  (0, _react.useEffect)(() => {
    if (init.current) {
      init.current = false;
      onChange({
        category,
        destIp,
        malwareHash,
        malwareUrl,
        priority,
        sourceIp,
        subcategory
      });
    }
  }, [category, destIp, malwareHash, malwareUrl, onChange, priority, sourceIp, subcategory]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConnectorWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, null))), isEdit ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "connector-fields-sn-sir"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.ALERT_FIELDS_LABEL
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "destIpCheckbox",
    "data-test-subj": "destIpCheckbox",
    label: i18n.DEST_IP,
    checked: destIp !== null && destIp !== void 0 ? destIp : false,
    compressed: true,
    onChange: e => onChangeCb('destIp', e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "sourceIpCheckbox",
    "data-test-subj": "sourceIpCheckbox",
    label: i18n.SOURCE_IP,
    checked: sourceIp !== null && sourceIp !== void 0 ? sourceIp : false,
    compressed: true,
    onChange: e => onChangeCb('sourceIp', e.target.checked)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "malwareUrlCheckbox",
    "data-test-subj": "malwareUrlCheckbox",
    label: i18n.MALWARE_URL,
    checked: malwareUrl !== null && malwareUrl !== void 0 ? malwareUrl : false,
    compressed: true,
    onChange: e => onChangeCb('malwareUrl', e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "malwareHashCheckbox",
    "data-test-subj": "malwareHashCheckbox",
    label: i18n.MALWARE_HASH,
    checked: malwareHash !== null && malwareHash !== void 0 ? malwareHash : false,
    compressed: true,
    onChange: e => onChangeCb('malwareHash', e.target.checked)
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.PRIORITY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "prioritySelect",
    hasNoInitialSelection: true,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: priorityOptions,
    value: priority !== null && priority !== void 0 ? priority : undefined,
    onChange: e => onChangeCb('priority', e.target.value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.CATEGORY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "categorySelect",
    options: categoryOptions,
    value: category !== null && category !== void 0 ? category : undefined,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    hasNoInitialSelection: true,
    onChange: e => onChange({
      ...fields,
      category: e.target.value,
      subcategory: null
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, (subcategoryOptions === null || subcategoryOptions === void 0 ? void 0 : subcategoryOptions.length) > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.SUBCATEGORY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "subcategorySelect",
    options: subcategoryOptions
    // Needs an empty string instead of undefined to select the blank option when changing categories
    ,
    value: subcategory !== null && subcategory !== void 0 ? subcategory : '',
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    hasNoInitialSelection: true,
    onChange: e => onChangeCb('subcategory', e.target.value)
  })) : null))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _api.ConnectorTypes.serviceNowSIR,
    title: connector.name,
    listItems: listItems,
    isLoading: false
  }))));
};
exports.default = ServiceNowSIRFieldsComponent;
ServiceNowSIRFieldsComponent.displayName = 'ServiceNowSIRFieldsComponent';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;