"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../../../../common/api");
var _kibana = require("../../../common/lib/kibana");
var _card = require("../card");
var _use_get_choices = require("./use_get_choices");
var _helpers = require("./helpers");
var _deprecated_callout = require("../deprecated_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetChoicesFields = ['urgency', 'severity', 'impact', 'category', 'subcategory'];
const defaultFields = {
  urgency: [],
  severity: [],
  impact: [],
  category: [],
  subcategory: []
};
const ServiceNowITSMFieldsComponent =
// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
({
  isEdit = true,
  fields,
  connector,
  onChange
}) => {
  const init = (0, _react.useRef)(true);
  const {
    severity = null,
    urgency = null,
    impact = null,
    category = null,
    subcategory = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http,
    notifications
  } = (0, _kibana.useKibana)().services;
  const [choices, setChoices] = (0, _react.useState)(defaultFields);
  const showConnectorWarning = connector.isDeprecated;
  const categoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.category), [choices.category]);
  const urgencyOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.urgency), [choices.urgency]);
  const severityOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.severity), [choices.severity]);
  const impactOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.impact), [choices.impact]);
  const subcategoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.subcategory.filter(choice => choice.dependent_value === category)), [choices.subcategory, category]);
  const listItems = (0, _react.useMemo)(() => {
    var _urgencyOptions$find, _severityOptions$find, _impactOptions$find, _categoryOptions$find, _subcategoryOptions$f;
    return [...(urgency != null && urgency.length > 0 ? [{
      title: i18n.URGENCY,
      description: (_urgencyOptions$find = urgencyOptions.find(option => `${option.value}` === urgency)) === null || _urgencyOptions$find === void 0 ? void 0 : _urgencyOptions$find.text
    }] : []), ...(severity != null && severity.length > 0 ? [{
      title: i18n.SEVERITY,
      description: (_severityOptions$find = severityOptions.find(option => `${option.value}` === severity)) === null || _severityOptions$find === void 0 ? void 0 : _severityOptions$find.text
    }] : []), ...(impact != null && impact.length > 0 ? [{
      title: i18n.IMPACT,
      description: (_impactOptions$find = impactOptions.find(option => `${option.value}` === impact)) === null || _impactOptions$find === void 0 ? void 0 : _impactOptions$find.text
    }] : []), ...(category != null && category.length > 0 ? [{
      title: i18n.CATEGORY,
      description: (_categoryOptions$find = categoryOptions.find(option => `${option.value}` === category)) === null || _categoryOptions$find === void 0 ? void 0 : _categoryOptions$find.text
    }] : []), ...(subcategory != null && subcategory.length > 0 ? [{
      title: i18n.SUBCATEGORY,
      description: (_subcategoryOptions$f = subcategoryOptions.find(option => `${option.value}` === subcategory)) === null || _subcategoryOptions$f === void 0 ? void 0 : _subcategoryOptions$f.text
    }] : [])];
  }, [category, categoryOptions, impact, impactOptions, severity, severityOptions, subcategory, subcategoryOptions, urgency, urgencyOptions]);
  const onChoicesSuccess = values => {
    setChoices(values.reduce((acc, value) => ({
      ...acc,
      [value.element]: [...(acc[value.element] != null ? acc[value.element] : []), value]
    }), defaultFields));
  };
  const {
    isLoading: isLoadingChoices
  } = (0, _use_get_choices.useGetChoices)({
    http,
    toastNotifications: notifications.toasts,
    connector,
    fields: useGetChoicesFields,
    onSuccess: onChoicesSuccess
  });
  const onChangeCb = (0, _react.useCallback)((key, value) => {
    onChange({
      ...fields,
      [key]: value
    });
  }, [fields, onChange]);

  // Set field at initialization
  (0, _react.useEffect)(() => {
    if (init.current) {
      init.current = false;
      onChange({
        urgency,
        severity,
        impact,
        category,
        subcategory
      });
    }
  }, [category, impact, onChange, severity, subcategory, urgency]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConnectorWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, null))), isEdit ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "connector-fields-sn-itsm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.URGENCY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "urgencySelect",
    options: urgencyOptions,
    value: urgency !== null && urgency !== void 0 ? urgency : undefined,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    hasNoInitialSelection: true,
    onChange: e => onChangeCb('urgency', e.target.value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.SEVERITY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "severitySelect",
    options: severityOptions,
    value: severity !== null && severity !== void 0 ? severity : undefined,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    hasNoInitialSelection: true,
    onChange: e => onChangeCb('severity', e.target.value)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.IMPACT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "impactSelect",
    options: impactOptions,
    value: impact !== null && impact !== void 0 ? impact : undefined,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    hasNoInitialSelection: true,
    onChange: e => onChangeCb('impact', e.target.value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.CATEGORY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "categorySelect",
    options: categoryOptions,
    value: category !== null && category !== void 0 ? category : undefined,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    hasNoInitialSelection: true,
    onChange: e => onChange({
      ...fields,
      category: e.target.value,
      subcategory: null
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, (subcategoryOptions === null || subcategoryOptions === void 0 ? void 0 : subcategoryOptions.length) > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.SUBCATEGORY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "subcategorySelect",
    options: subcategoryOptions
    // Needs an empty string instead of undefined to select the blank option when changing categories
    ,
    value: subcategory !== null && subcategory !== void 0 ? subcategory : '',
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    hasNoInitialSelection: true,
    onChange: e => onChangeCb('subcategory', e.target.value)
  })) : null))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _api.ConnectorTypes.serviceNowITSM,
    title: connector.name,
    listItems: listItems,
    isLoading: false
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = ServiceNowITSMFieldsComponent;
module.exports = exports.default;