"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetIncidentTypes = void 0;
var _react = require("react");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetIncidentTypes = ({
  http,
  toastNotifications,
  connector
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [incidentTypes, setIncidentTypes] = (0, _react.useState)([]);
  const didCancel = (0, _react.useRef)(false);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  (0, _react.useEffect)(() => {
    const fetchData = async () => {
      if (!connector) {
        setIsLoading(false);
        return;
      }
      try {
        abortCtrl.current = new AbortController();
        setIsLoading(true);
        const res = await (0, _api.getIncidentTypes)({
          http,
          signal: abortCtrl.current.signal,
          connectorId: connector.id
        });
        if (!didCancel.current) {
          var _res$data;
          setIsLoading(false);
          setIncidentTypes((_res$data = res.data) !== null && _res$data !== void 0 ? _res$data : []);
          if (res.status && res.status === 'error') {
            var _res$serviceMessage;
            toastNotifications.addDanger({
              title: i18n.INCIDENT_TYPES_API_ERROR,
              text: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
            });
          }
        }
      } catch (error) {
        if (!didCancel.current) {
          setIsLoading(false);
          if (error.name !== 'AbortError') {
            toastNotifications.addDanger({
              title: i18n.INCIDENT_TYPES_API_ERROR,
              text: error.message
            });
          }
        }
      }
    };
    didCancel.current = false;
    abortCtrl.current.abort();
    fetchData();
    return () => {
      didCancel.current = true;
      abortCtrl.current.abort();
    };
  }, [http, connector, toastNotifications]);
  return {
    incidentTypes,
    isLoading
  };
};
exports.useGetIncidentTypes = useGetIncidentTypes;