"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../common/lib/kibana");
var _use_get_incident_types = require("./use_get_incident_types");
var _use_get_severity = require("./use_get_severity");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../../../../common/api");
var _card = require("../card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResilientFieldsComponent =
// TODO: Fix this manually. Issue #123375
// eslint-disable-next-line react/display-name
({
  isEdit = true,
  fields,
  connector,
  onChange
}) => {
  const init = (0, _react.useRef)(true);
  const {
    incidentTypes = null,
    severityCode = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http,
    notifications
  } = (0, _kibana.useKibana)().services;
  const {
    isLoading: isLoadingIncidentTypes,
    incidentTypes: allIncidentTypes
  } = (0, _use_get_incident_types.useGetIncidentTypes)({
    http,
    toastNotifications: notifications.toasts,
    connector
  });
  const {
    isLoading: isLoadingSeverity,
    severity
  } = (0, _use_get_severity.useGetSeverity)({
    http,
    toastNotifications: notifications.toasts,
    connector
  });
  const severitySelectOptions = (0, _react.useMemo)(() => severity.map(s => ({
    value: s.id.toString(),
    text: s.name
  })), [severity]);
  const incidentTypesComboBoxOptions = (0, _react.useMemo)(() => allIncidentTypes ? allIncidentTypes.map(type => ({
    label: type.name,
    value: type.id.toString()
  })) : [], [allIncidentTypes]);
  const listItems = (0, _react.useMemo)(() => {
    var _severity$find$name, _severity$find;
    return [...(incidentTypes != null && incidentTypes.length > 0 ? [{
      title: i18n.INCIDENT_TYPES_LABEL,
      description: allIncidentTypes.filter(type => incidentTypes.includes(type.id.toString())).map(type => type.name).join(', ')
    }] : []), ...(severityCode != null && severityCode.length > 0 ? [{
      title: i18n.SEVERITY_LABEL,
      description: (_severity$find$name = (_severity$find = severity.find(severityObj => severityObj.id.toString() === severityCode)) === null || _severity$find === void 0 ? void 0 : _severity$find.name) !== null && _severity$find$name !== void 0 ? _severity$find$name : ''
    }] : [])];
  }, [incidentTypes, severityCode, allIncidentTypes, severity]);
  const onFieldChange = (0, _react.useCallback)((key, value) => {
    onChange({
      ...fields,
      incidentTypes,
      severityCode,
      [key]: value
    });
  }, [incidentTypes, severityCode, onChange, fields]);
  const selectedIncidentTypesComboBoxOptionsMemo = (0, _react.useMemo)(() => {
    const allIncidentTypesAsObject = allIncidentTypes.reduce((acc, type) => ({
      ...acc,
      [type.id.toString()]: type.name
    }), {});
    return incidentTypes ? incidentTypes.map(type => ({
      label: allIncidentTypesAsObject[type.toString()],
      value: type.toString()
    })).filter(type => type.label != null) : [];
  }, [allIncidentTypes, incidentTypes]);
  const onIncidentChange = (0, _react.useCallback)(selectedOptions => {
    onFieldChange('incidentTypes', selectedOptions.map(selectedOption => {
      var _selectedOption$value;
      return (_selectedOption$value = selectedOption.value) !== null && _selectedOption$value !== void 0 ? _selectedOption$value : selectedOption.label;
    }));
  }, [onFieldChange]);
  const onIncidentBlur = (0, _react.useCallback)(() => {
    if (!incidentTypes) {
      onFieldChange('incidentTypes', []);
    }
  }, [incidentTypes, onFieldChange]);

  // Set field at initialization
  (0, _react.useEffect)(() => {
    if (init.current) {
      init.current = false;
      onChange({
        incidentTypes,
        severityCode
      });
    }
  }, [incidentTypes, onChange, severityCode]);
  return isEdit ? /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": 'connector-fields-resilient'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.INCIDENT_TYPES_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "incidentTypeComboBox",
    fullWidth: true,
    isClearable: true,
    isDisabled: isLoadingIncidentTypes,
    isLoading: isLoadingIncidentTypes,
    onBlur: onIncidentBlur,
    onChange: onIncidentChange,
    options: incidentTypesComboBoxOptions,
    placeholder: i18n.INCIDENT_TYPES_PLACEHOLDER,
    selectedOptions: selectedIncidentTypesComboBoxOptionsMemo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.SEVERITY_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "severitySelect",
    disabled: isLoadingSeverity,
    fullWidth: true,
    hasNoInitialSelection: true,
    isLoading: isLoadingSeverity,
    onChange: e => onFieldChange('severityCode', e.target.value),
    options: severitySelectOptions,
    value: severityCode !== null && severityCode !== void 0 ? severityCode : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _api.ConnectorTypes.resilient,
    isLoading: isLoadingIncidentTypes || isLoadingSeverity,
    listItems: listItems,
    title: connector.name
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = ResilientFieldsComponent;
module.exports = exports.default;