"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetSingleIssue = void 0;
var _react = require("react");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetSingleIssue = ({
  http,
  toastNotifications,
  actionConnector,
  id
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [issue, setIssue] = (0, _react.useState)(null);
  const didCancel = (0, _react.useRef)(false);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  (0, _react.useEffect)(() => {
    const fetchData = async () => {
      if (!actionConnector || !id) {
        setIsLoading(false);
        return;
      }
      abortCtrl.current = new AbortController();
      setIsLoading(true);
      try {
        const res = await (0, _api.getIssue)({
          http,
          signal: abortCtrl.current.signal,
          connectorId: actionConnector.id,
          id
        });
        if (!didCancel.current) {
          var _res$data;
          setIsLoading(false);
          setIssue((_res$data = res.data) !== null && _res$data !== void 0 ? _res$data : null);
          if (res.status && res.status === 'error') {
            var _res$serviceMessage;
            toastNotifications.addDanger({
              title: i18n.GET_ISSUE_API_ERROR(id),
              text: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
            });
          }
        }
      } catch (error) {
        if (!didCancel.current) {
          setIsLoading(false);
          if (error.name !== 'AbortError') {
            toastNotifications.addDanger({
              title: i18n.GET_ISSUE_API_ERROR(id),
              text: error.message
            });
          }
        }
      }
    };
    didCancel.current = false;
    abortCtrl.current.abort();
    fetchData();
    return () => {
      didCancel.current = true;
      abortCtrl.current.abort();
    };
  }, [http, actionConnector, id, toastNotifications]);
  return {
    isLoading,
    issue
  };
};
exports.useGetSingleIssue = useGetSingleIssue;