"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_ISSUES_PLACEHOLDER = exports.SEARCH_ISSUES_LOADING = exports.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL = exports.PRIORITY = exports.PARENT_ISSUE = exports.ISSUE_TYPES_API_ERROR = exports.ISSUE_TYPE = exports.ISSUES_API_ERROR = exports.GET_ISSUE_API_ERROR = exports.FIELDS_API_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ISSUE_TYPES_API_ERROR = _i18n.i18n.translate('xpack.cases.connectors.jira.unableToGetIssueTypesMessage', {
  defaultMessage: 'Unable to get issue types'
});
exports.ISSUE_TYPES_API_ERROR = ISSUE_TYPES_API_ERROR;
const FIELDS_API_ERROR = _i18n.i18n.translate('xpack.cases.connectors.jira.unableToGetFieldsMessage', {
  defaultMessage: 'Unable to get connectors'
});
exports.FIELDS_API_ERROR = FIELDS_API_ERROR;
const ISSUES_API_ERROR = _i18n.i18n.translate('xpack.cases.connectors.jira.unableToGetIssuesMessage', {
  defaultMessage: 'Unable to get issues'
});
exports.ISSUES_API_ERROR = ISSUES_API_ERROR;
const GET_ISSUE_API_ERROR = id => _i18n.i18n.translate('xpack.cases.connectors.jira.unableToGetIssueMessage', {
  defaultMessage: 'Unable to get issue with id {id}',
  values: {
    id
  }
});
exports.GET_ISSUE_API_ERROR = GET_ISSUE_API_ERROR;
const SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL = _i18n.i18n.translate('xpack.cases.connectors.jira.searchIssuesComboBoxAriaLabel', {
  defaultMessage: 'Type to search'
});
exports.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL = SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL;
const SEARCH_ISSUES_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.connectors.jira.searchIssuesComboBoxPlaceholder', {
  defaultMessage: 'Type to search'
});
exports.SEARCH_ISSUES_PLACEHOLDER = SEARCH_ISSUES_PLACEHOLDER;
const SEARCH_ISSUES_LOADING = _i18n.i18n.translate('xpack.cases.connectors.jira.searchIssuesLoading', {
  defaultMessage: 'Loading...'
});
exports.SEARCH_ISSUES_LOADING = SEARCH_ISSUES_LOADING;
const PRIORITY = _i18n.i18n.translate('xpack.cases.connectors.jira.prioritySelectFieldLabel', {
  defaultMessage: 'Priority'
});
exports.PRIORITY = PRIORITY;
const ISSUE_TYPE = _i18n.i18n.translate('xpack.cases.connectors.jira.issueTypesSelectFieldLabel', {
  defaultMessage: 'Issue type'
});
exports.ISSUE_TYPE = ISSUE_TYPE;
const PARENT_ISSUE = _i18n.i18n.translate('xpack.cases.connectors.jira.parentIssueSearchLabel', {
  defaultMessage: 'Parent issue'
});
exports.PARENT_ISSUE = PARENT_ISSUE;