"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../../../../common/api");
var _kibana = require("../../../common/lib/kibana");
var _use_get_issue_types = require("./use_get_issue_types");
var _use_get_fields_by_issue_type = require("./use_get_fields_by_issue_type");
var _search_issues = require("./search_issues");
var _card = require("../card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JiraFieldsComponent = ({
  connector,
  fields,
  isEdit = true,
  onChange
}) => {
  const init = (0, _react.useRef)(true);
  const {
    issueType = null,
    priority = null,
    parent = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http,
    notifications
  } = (0, _kibana.useKibana)().services;
  const handleIssueType = (0, _react.useCallback)(issueTypeSelectOptions => {
    if (issueType == null && issueTypeSelectOptions.length > 0) {
      // if there is no issue type set in the edit view, set it to default
      if (isEdit) {
        onChange({
          issueType: issueTypeSelectOptions[0].value,
          parent,
          priority
        });
      }
    }
  }, [isEdit, issueType, onChange, parent, priority]);
  const {
    isLoading: isLoadingIssueTypes,
    issueTypes
  } = (0, _use_get_issue_types.useGetIssueTypes)({
    connector,
    http,
    toastNotifications: notifications.toasts,
    handleIssueType
  });
  const issueTypesSelectOptions = (0, _react.useMemo)(() => issueTypes.map(type => {
    var _type$name, _type$id;
    return {
      text: (_type$name = type.name) !== null && _type$name !== void 0 ? _type$name : '',
      value: (_type$id = type.id) !== null && _type$id !== void 0 ? _type$id : ''
    };
  }), [issueTypes]);
  const currentIssueType = (0, _react.useMemo)(() => {
    if (!issueType && issueTypesSelectOptions.length > 0) {
      return issueTypesSelectOptions[0].value;
    } else if (issueTypesSelectOptions.length > 0 && !issueTypesSelectOptions.some(({
      value
    }) => value === issueType)) {
      return issueTypesSelectOptions[0].value;
    }
    return issueType;
  }, [issueType, issueTypesSelectOptions]);
  const {
    isLoading: isLoadingFields,
    fields: fieldsByIssueType
  } = (0, _use_get_fields_by_issue_type.useGetFieldsByIssueType)({
    connector,
    http,
    issueType: currentIssueType,
    toastNotifications: notifications.toasts
  });
  const hasPriority = (0, _react.useMemo)(() => fieldsByIssueType.priority != null, [fieldsByIssueType]);
  const hasParent = (0, _react.useMemo)(() => fieldsByIssueType.parent != null, [fieldsByIssueType]);
  const prioritiesSelectOptions = (0, _react.useMemo)(() => {
    var _fieldsByIssueType$pr, _fieldsByIssueType$pr2;
    const priorities = (_fieldsByIssueType$pr = (_fieldsByIssueType$pr2 = fieldsByIssueType.priority) === null || _fieldsByIssueType$pr2 === void 0 ? void 0 : _fieldsByIssueType$pr2.allowedValues) !== null && _fieldsByIssueType$pr !== void 0 ? _fieldsByIssueType$pr : [];
    return (0, _fp.map)(p => ({
      text: p.name,
      value: p.name
    }), priorities);
  }, [fieldsByIssueType]);
  const listItems = (0, _react.useMemo)(() => {
    var _issueTypes$find$name, _issueTypes$find;
    return [...(issueType != null && issueType.length > 0 ? [{
      title: i18n.ISSUE_TYPE,
      description: (_issueTypes$find$name = (_issueTypes$find = issueTypes.find(issue => issue.id === issueType)) === null || _issueTypes$find === void 0 ? void 0 : _issueTypes$find.name) !== null && _issueTypes$find$name !== void 0 ? _issueTypes$find$name : ''
    }] : []), ...(parent != null && parent.length > 0 ? [{
      title: i18n.PARENT_ISSUE,
      description: parent
    }] : []), ...(priority != null && priority.length > 0 ? [{
      title: i18n.PRIORITY,
      description: priority
    }] : [])];
  }, [issueType, issueTypes, parent, priority]);
  const onFieldChange = (0, _react.useCallback)((key, value) => {
    if (key === 'issueType') {
      return onChange({
        ...fields,
        issueType: value,
        priority: null,
        parent: null
      });
    }
    return onChange({
      ...fields,
      issueType: currentIssueType,
      parent,
      priority,
      [key]: value
    });
  }, [currentIssueType, fields, onChange, parent, priority]);

  // Set field at initialization
  (0, _react.useEffect)(() => {
    if (init.current) {
      init.current = false;
      onChange({
        issueType,
        priority,
        parent
      });
    }
  }, [issueType, onChange, parent, priority]);
  return isEdit ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'connector-fields-jira'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.ISSUE_TYPE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "issueTypeSelect",
    disabled: isLoadingIssueTypes || isLoadingFields,
    fullWidth: true,
    isLoading: isLoadingIssueTypes,
    onChange: e => onFieldChange('issueType', e.target.value),
    options: issueTypesSelectOptions,
    value: currentIssueType !== null && currentIssueType !== void 0 ? currentIssueType : ''
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasParent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.PARENT_ISSUE
  }, /*#__PURE__*/_react.default.createElement(_search_issues.SearchIssues, {
    actionConnector: connector,
    onChange: parentIssueKey => onFieldChange('parent', parentIssueKey),
    selectedValue: parent
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), hasPriority && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.PRIORITY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "prioritySelect",
    disabled: isLoadingIssueTypes || isLoadingFields,
    fullWidth: true,
    hasNoInitialSelection: true,
    isLoading: isLoadingFields,
    onChange: e => onFieldChange('priority', e.target.value),
    options: prioritiesSelectOptions,
    value: priority !== null && priority !== void 0 ? priority : ''
  }))))))) : /*#__PURE__*/_react.default.createElement(_card.ConnectorCard, {
    connectorType: _api.ConnectorTypes.jira,
    isLoading: isLoadingIssueTypes || isLoadingFields,
    listItems: listItems,
    title: connector.name
  });
};
exports.default = JiraFieldsComponent;
JiraFieldsComponent.displayName = 'JiraFields';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;