"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/actions-plugin/common");
var _kibana = require("../../common/lib/kibana");
var _use_action_types = require("../../containers/configure/use_action_types");
var _use_configure = require("../../containers/configure/use_configure");
var _wrappers = require("../wrappers");
var _connectors = require("./connectors");
var _closure_options = require("./closure_options");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils2 = require("../utils");
var _header_page = require("../header_page");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_breadcrumbs = require("../use_breadcrumbs");
var _navigation = require("../../common/navigation");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormWrapper = _styledComponents.default.div`
  ${({
  theme
}) => (0, _styledComponents.css)`
    & > * {
      margin-top 40px;
    }

    & > :first-child {
      margin-top: 0;
    }

    padding-top: ${theme.eui.euiSizeXL};
    padding-bottom: ${theme.eui.euiSizeXL};
    .euiFlyout {
      z-index: ${theme.eui.euiZNavigation + 1};
    }
  `}
`;
const ConfigureCases = /*#__PURE__*/_react.default.memo(() => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  (0, _use_breadcrumbs.useCasesBreadcrumbs)(_navigation.CasesDeepLinkId.casesConfigure);
  const [connectorIsValid, setConnectorIsValid] = (0, _react.useState)(true);
  const [addFlyoutVisible, setAddFlyoutVisibility] = (0, _react.useState)(false);
  const [editFlyoutVisible, setEditFlyoutVisibility] = (0, _react.useState)(false);
  const [editedConnectorItem, setEditedConnectorItem] = (0, _react.useState)(null);
  const {
    connector,
    closureType,
    loading: loadingCaseConfigure,
    mappings,
    persistLoading,
    persistCaseConfigure,
    refetchCaseConfigure,
    setConnector,
    setClosureType
  } = (0, _use_configure.useCaseConfigure)();
  const {
    isLoading: isLoadingConnectors,
    data: connectors = [],
    refetch: refetchConnectors
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const {
    isLoading: isLoadingActionTypes,
    data: actionTypes = [],
    refetch: refetchActionTypes
  } = (0, _use_action_types.useGetActionTypes)();
  const onConnectorUpdated = (0, _react.useCallback)(async updatedConnector => {
    setEditedConnectorItem(updatedConnector);
    refetchConnectors();
    refetchActionTypes();
    refetchCaseConfigure();
  }, [refetchActionTypes, refetchCaseConfigure, refetchConnectors, setEditedConnectorItem]);
  const onConnectorCreated = (0, _react.useCallback)(async createdConnector => {
    const caseConnector = (0, _utils.normalizeActionConnector)(createdConnector);
    await persistCaseConfigure({
      connector: caseConnector,
      closureType
    });
    onConnectorUpdated(createdConnector);
    setConnector(caseConnector);
  }, [onConnectorUpdated, closureType, setConnector, persistCaseConfigure]);
  const isLoadingAny = isLoadingConnectors || persistLoading || loadingCaseConfigure || isLoadingActionTypes;
  const updateConnectorDisabled = isLoadingAny || !connectorIsValid || connector.id === 'none';
  const onClickUpdateConnector = (0, _react.useCallback)(() => {
    setEditFlyoutVisibility(true);
  }, []);
  const onCloseAddFlyout = (0, _react.useCallback)(() => setAddFlyoutVisibility(false), [setAddFlyoutVisibility]);
  const onCloseEditFlyout = (0, _react.useCallback)(() => setEditFlyoutVisibility(false), []);
  const onChangeConnector = (0, _react.useCallback)(id => {
    if (id === 'add-connector') {
      setAddFlyoutVisibility(true);
      return;
    }
    const actionConnector = (0, _utils2.getConnectorById)(id, connectors);
    const caseConnector = actionConnector != null ? (0, _utils.normalizeActionConnector)(actionConnector) : (0, _utils.getNoneConnector)();
    setConnector(caseConnector);
    persistCaseConfigure({
      connector: caseConnector,
      closureType
    });
  }, [connectors, closureType, persistCaseConfigure, setConnector]);
  const onChangeClosureType = (0, _react.useCallback)(type => {
    setClosureType(type);
    persistCaseConfigure({
      connector,
      closureType: type
    });
  }, [connector, persistCaseConfigure, setClosureType]);
  (0, _react.useEffect)(() => {
    if (!isLoadingConnectors && connector.id !== 'none' && !connectors.some(c => c.id === connector.id)) {
      setConnectorIsValid(false);
    } else if (!isLoadingConnectors && (connector.id === 'none' || connectors.some(c => c.id === connector.id))) {
      setConnectorIsValid(true);
    }
  }, [connectors, connector, isLoadingConnectors]);
  (0, _react.useEffect)(() => {
    if (!isLoadingConnectors && connector.id !== 'none') {
      setEditedConnectorItem((0, _utils.normalizeCaseConnector)(connectors, connector));
    }
  }, [connectors, connector, isLoadingConnectors]);
  const ConnectorAddFlyout = (0, _react.useMemo)(() => addFlyoutVisible ? triggersActionsUi.getAddConnectorFlyout({
    onClose: onCloseAddFlyout,
    featureId: _common.CasesConnectorFeatureId,
    onConnectorCreated
  }) : null,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [addFlyoutVisible]);
  const ConnectorEditFlyout = (0, _react.useMemo)(() => editedConnectorItem && editFlyoutVisible ? triggersActionsUi.getEditConnectorFlyout({
    connector: editedConnectorItem,
    onClose: onCloseEditFlyout,
    onConnectorUpdated
  }) : null,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [connector.id, editedConnectorItem, editFlyoutVisible]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    showBackButton: true,
    "data-test-subj": "case-configure-title",
    title: i18n.CONFIGURE_CASES_PAGE_TITLE
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(FormWrapper, null, !connectorIsValid && /*#__PURE__*/_react.default.createElement(_wrappers.SectionWrapper, {
    style: {
      marginTop: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.WARNING_NO_CONNECTOR_TITLE,
    color: "warning",
    iconType: "help",
    "data-test-subj": "configure-cases-warning-callout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The selected connector has been deleted or you do not have the {appropriateLicense} to use it. Either select a different connector or create a new one.",
    id: "xpack.cases.configure.connectorDeletedOrLicenseWarning",
    values: {
      appropriateLicense: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/subscriptions",
        target: "_blank"
      }, i18n.LINK_APPROPRIATE_LICENSE)
    }
  }))), /*#__PURE__*/_react.default.createElement(_wrappers.SectionWrapper, null, /*#__PURE__*/_react.default.createElement(_closure_options.ClosureOptions, {
    closureTypeSelected: closureType,
    disabled: persistLoading || isLoadingConnectors || !permissions.update,
    onChangeClosureType: onChangeClosureType
  })), /*#__PURE__*/_react.default.createElement(_wrappers.SectionWrapper, null, /*#__PURE__*/_react.default.createElement(_connectors.Connectors, {
    actionTypes: actionTypes,
    connectors: connectors !== null && connectors !== void 0 ? connectors : [],
    disabled: persistLoading || isLoadingConnectors || !permissions.update,
    handleShowEditFlyout: onClickUpdateConnector,
    isLoading: isLoadingAny,
    mappings: mappings,
    onChangeConnector: onChangeConnector,
    selectedConnector: connector,
    updateConnectorDisabled: updateConnectorDisabled || !permissions.update
  })), ConnectorAddFlyout, ConnectorEditFlyout)));
});
exports.ConfigureCases = ConfigureCases;
ConfigureCases.displayName = 'ConfigureCases';