"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsDropdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/kibana-react-plugin/common");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../common/lib/kibana");
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON_SIZE = 'm';
const EuiIconExtended = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: 13px;
  margin-bottom: 0 !important;
`;
const noConnectorOption = {
  value: 'none',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(EuiIconExtended, {
    type: "minusInCircle",
    size: ICON_SIZE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `dropdown-connector-no-connector`
  }, i18n.NO_CONNECTOR))),
  'data-test-subj': 'dropdown-connector-no-connector'
};
const addNewConnector = {
  value: 'add-connector',
  inputDisplay: /*#__PURE__*/_react.default.createElement("span", {
    className: "euiButtonEmpty euiButtonEmpty--primary euiButtonEmpty--xSmall euiButtonEmpty--flushLeft"
  }, i18n.ADD_NEW_CONNECTOR),
  'data-test-subj': 'dropdown-connector-add-connector'
};
const StyledEuiIconTip = (0, _common.euiStyled)(_eui.EuiIconTip)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS}
  margin-bottom: 0 !important;
`;
const ConnectorsDropdownComponent = ({
  connectors,
  disabled,
  isLoading,
  onChange,
  selectedConnector,
  appendAddConnectorButton = false
}) => {
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const connectorsAsOptions = (0, _react.useMemo)(() => {
    const connectorsFormatted = connectors.reduce((acc, connector) => {
      return [...acc, {
        value: connector.id,
        inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          responsive: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(EuiIconExtended, {
          type: (0, _utils.getConnectorIcon)(triggersActionsUi, connector.actionTypeId),
          size: ICON_SIZE
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement("span", null, connector.name, (0, _utils.isDeprecatedConnector)(connector) && ` (${i18n.DEPRECATED_TOOLTIP_TEXT})`)), (0, _utils.isDeprecatedConnector)(connector) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(StyledEuiIconTip, {
          "aria-label": i18n.DEPRECATED_TOOLTIP_CONTENT,
          size: ICON_SIZE,
          type: "warning",
          color: "warning",
          content: i18n.DEPRECATED_TOOLTIP_CONTENT
        }))),
        'data-test-subj': `dropdown-connector-${connector.id}`
      }];
    }, [noConnectorOption]);
    if (appendAddConnectorButton) {
      return [...connectorsFormatted, addNewConnector];
    }
    return connectorsFormatted;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [connectors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "aria-label": i18n.INCIDENT_MANAGEMENT_SYSTEM_LABEL,
    "data-test-subj": "dropdown-connectors",
    disabled: disabled,
    fullWidth: true,
    isLoading: isLoading,
    onChange: onChange,
    options: connectorsAsOptions,
    valueOfSelected: selectedConnector
  });
};
ConnectorsDropdownComponent.displayName = 'ConnectorsDropdown';
const ConnectorsDropdown = /*#__PURE__*/_react.default.memo(ConnectorsDropdownComponent);
exports.ConnectorsDropdown = ConnectorsDropdown;