"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Connectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _connectors_dropdown = require("./connectors_dropdown");
var i18n = _interopRequireWildcard(require("./translations"));
var _mapping = require("./mapping");
var _api = require("../../../common/api");
var _deprecated_callout = require("../connectors/deprecated_callout");
var _utils = require("../utils");
var _kibana = require("../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiFormRowExtended = (0, _styledComponents.default)(_eui.EuiFormRow)`
  .euiFormRow__labelWrapper {
    .euiFormRow__label {
      width: 100%;
    }
  }
`;
const ConnectorsComponent = ({
  actionTypes,
  connectors,
  disabled,
  handleShowEditFlyout,
  isLoading,
  mappings,
  onChangeConnector,
  selectedConnector,
  updateConnectorDisabled
}) => {
  var _connector$name;
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  const connector = (0, _react.useMemo)(() => connectors.find(c => c.id === selectedConnector.id), [connectors, selectedConnector.id]);
  const connectorsName = (_connector$name = connector === null || connector === void 0 ? void 0 : connector.name) !== null && _connector$name !== void 0 ? _connector$name : 'none';
  const actionTypeName = (0, _react.useMemo)(() => {
    var _actionTypes$find$nam, _actionTypes$find;
    return (_actionTypes$find$nam = (_actionTypes$find = actionTypes.find(c => c.id === selectedConnector.type)) === null || _actionTypes$find === void 0 ? void 0 : _actionTypes$find.name) !== null && _actionTypes$find$nam !== void 0 ? _actionTypes$find$nam : i18n.UNKNOWN;
  }, [actionTypes, selectedConnector.type]);
  const dropDownLabel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, i18n.INCIDENT_MANAGEMENT_SYSTEM_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, connectorsName !== 'none' && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    disabled: updateConnectorDisabled,
    onClick: handleShowEditFlyout,
    "data-test-subj": "case-configure-update-selected-connector-button"
  }, i18n.UPDATE_SELECTED_CONNECTOR(connectorsName)))), [connectorsName, handleShowEditFlyout, updateConnectorDisabled]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.INCIDENT_MANAGEMENT_SYSTEM_TITLE),
    description: i18n.INCIDENT_MANAGEMENT_SYSTEM_DESC,
    "data-test-subj": "case-connectors-form-group"
  }, /*#__PURE__*/_react.default.createElement(EuiFormRowExtended, {
    fullWidth: true,
    label: dropDownLabel,
    "data-test-subj": "case-connectors-form-row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, actions.read ? /*#__PURE__*/_react.default.createElement(_connectors_dropdown.ConnectorsDropdown, {
    connectors: connectors,
    disabled: disabled,
    selectedConnector: selectedConnector.id,
    isLoading: isLoading,
    onChange: onChangeConnector,
    "data-test-subj": "case-connectors-dropdown",
    appendAddConnectorButton: true
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "configure-case-connector-permissions-error-msg",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.READ_ACTIONS_PERMISSIONS_ERROR_MSG))), selectedConnector.type !== _api.ConnectorTypes.none && (0, _utils.isDeprecatedConnector)(connector) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, null)), selectedConnector.type !== _api.ConnectorTypes.none ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_mapping.Mapping, {
    actionTypeName: actionTypeName,
    connectorType: selectedConnector.type,
    isLoading: isLoading,
    mappings: mappings
  })) : null))));
};
ConnectorsComponent.displayName = 'Connectors';
const Connectors = /*#__PURE__*/_react.default.memo(ConnectorsComponent);
exports.Connectors = Connectors;