"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectors = exports.actionTypes = void 0;
Object.defineProperty(exports, "mappings", {
  enumerable: true,
  get: function () {
    return _mock.mappings;
  }
});
exports.useConnectorsResponse = exports.useCaseConfigureResponse = exports.useActionTypesResponse = exports.searchURL = void 0;
var _api = require("../../../../common/api");
var _connectors = require("../../../common/mock/connectors");
var _mock = require("../../../containers/configure/mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectors = _connectors.connectorsMock;
exports.connectors = connectors;
const actionTypes = _connectors.actionTypesMock;
exports.actionTypes = actionTypes;
const searchURL = '?timerange=(global:(linkTo:!(),timerange:(from:1585487656371,fromStr:now-24h,kind:relative,to:1585574056371,toStr:now)),timeline:(linkTo:!(),timerange:(from:1585227005527,kind:absolute,to:1585313405527)))';
exports.searchURL = searchURL;
const useCaseConfigureResponse = {
  closureType: 'close-by-user',
  connector: {
    id: 'none',
    name: 'none',
    type: _api.ConnectorTypes.none,
    fields: null
  },
  currentConfiguration: {
    connector: {
      id: 'none',
      name: 'none',
      type: _api.ConnectorTypes.none,
      fields: null
    },
    closureType: 'close-by-user'
  },
  firstLoad: false,
  loading: false,
  mappings: [],
  persistCaseConfigure: jest.fn(),
  persistLoading: false,
  refetchCaseConfigure: jest.fn(),
  setClosureType: jest.fn(),
  setConnector: jest.fn(),
  setCurrentConfiguration: jest.fn(),
  setMappings: jest.fn(),
  version: '',
  id: ''
};
exports.useCaseConfigureResponse = useCaseConfigureResponse;
const useConnectorsResponse = {
  isLoading: false,
  data: connectors,
  refetch: jest.fn()
};
exports.useConnectorsResponse = useConnectorsResponse;
const useActionTypesResponse = {
  isLoading: false,
  data: _connectors.actionTypesMock,
  refetch: jest.fn()
};
exports.useActionTypesResponse = useActionTypesResponse;