"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ADDED_FIELD: true,
  CHANGED_FIELD: true,
  ENABLED_SETTING: true,
  DISABLED_SETTING: true,
  SELECTED_THIRD_PARTY: true,
  REMOVED_THIRD_PARTY: true,
  EDITED_FIELD: true,
  REMOVED_FIELD: true,
  VIEW_INCIDENT: true,
  PUSHED_NEW_INCIDENT: true,
  UPDATE_INCIDENT: true,
  ADDED_DESCRIPTION: true,
  EDIT_DESCRIPTION: true,
  COLLAPSE_DESCRIPTION: true,
  EXPAND_DESCRIPTION: true,
  QUOTE: true,
  EDIT_COMMENT: true,
  DELETE_COMMENT: true,
  DELETE_COMMENT_TITLE: true,
  ON: true,
  STATUS: true,
  CASE: true,
  COMMENT: true,
  CASE_REFRESH: true,
  ACTIVITY: true,
  EMAIL_SUBJECT: true,
  EMAIL_BODY: true,
  CHANGED_CONNECTOR_FIELD: true,
  SYNC_ALERTS: true,
  SYNC_ALERTS_LC: true,
  DOES_NOT_EXIST_TITLE: true,
  DOES_NOT_EXIST_DESCRIPTION: true,
  DOES_NOT_EXIST_BUTTON: true,
  ACTIVITY_TAB: true,
  ALERTS_TAB: true,
  FILES_TAB: true,
  ALERTS_EMPTY_DESCRIPTION: true,
  SEND_EMAIL_ARIA: true,
  EDIT_ASSIGNEES_ARIA_LABEL: true,
  NO_ASSIGNEES: true,
  ASSIGN_A_USER: true,
  SPACED_OR: true,
  ASSIGN_YOURSELF: true,
  TOTAL_USERS_ASSIGNED: true
};
exports.VIEW_INCIDENT = exports.UPDATE_INCIDENT = exports.TOTAL_USERS_ASSIGNED = exports.SYNC_ALERTS_LC = exports.SYNC_ALERTS = exports.STATUS = exports.SPACED_OR = exports.SEND_EMAIL_ARIA = exports.SELECTED_THIRD_PARTY = exports.REMOVED_THIRD_PARTY = exports.REMOVED_FIELD = exports.QUOTE = exports.PUSHED_NEW_INCIDENT = exports.ON = exports.NO_ASSIGNEES = exports.FILES_TAB = exports.EXPAND_DESCRIPTION = exports.ENABLED_SETTING = exports.EMAIL_SUBJECT = exports.EMAIL_BODY = exports.EDIT_DESCRIPTION = exports.EDIT_COMMENT = exports.EDIT_ASSIGNEES_ARIA_LABEL = exports.EDITED_FIELD = exports.DOES_NOT_EXIST_TITLE = exports.DOES_NOT_EXIST_DESCRIPTION = exports.DOES_NOT_EXIST_BUTTON = exports.DISABLED_SETTING = exports.DELETE_COMMENT_TITLE = exports.DELETE_COMMENT = exports.COMMENT = exports.COLLAPSE_DESCRIPTION = exports.CHANGED_FIELD = exports.CHANGED_CONNECTOR_FIELD = exports.CASE_REFRESH = exports.CASE = exports.ASSIGN_YOURSELF = exports.ASSIGN_A_USER = exports.ALERTS_TAB = exports.ALERTS_EMPTY_DESCRIPTION = exports.ADDED_FIELD = exports.ADDED_DESCRIPTION = exports.ACTIVITY_TAB = exports.ACTIVITY = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
var _translations2 = require("../user_profiles/translations");
Object.keys(_translations2).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations2[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations2[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADDED_FIELD = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.addedField', {
  defaultMessage: 'added'
});
exports.ADDED_FIELD = ADDED_FIELD;
const CHANGED_FIELD = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.changededField', {
  defaultMessage: 'changed'
});
exports.CHANGED_FIELD = CHANGED_FIELD;
const ENABLED_SETTING = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.enabledSetting', {
  defaultMessage: 'enabled'
});
exports.ENABLED_SETTING = ENABLED_SETTING;
const DISABLED_SETTING = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.disableSetting', {
  defaultMessage: 'disabled'
});
exports.DISABLED_SETTING = DISABLED_SETTING;
const SELECTED_THIRD_PARTY = thirdParty => _i18n.i18n.translate('xpack.cases.caseView.actionLabel.selectedThirdParty', {
  values: {
    thirdParty
  },
  defaultMessage: 'selected { thirdParty } as incident management system'
});
exports.SELECTED_THIRD_PARTY = SELECTED_THIRD_PARTY;
const REMOVED_THIRD_PARTY = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.removedThirdParty', {
  defaultMessage: 'removed external incident management system'
});
exports.REMOVED_THIRD_PARTY = REMOVED_THIRD_PARTY;
const EDITED_FIELD = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.editedField', {
  defaultMessage: 'edited'
});
exports.EDITED_FIELD = EDITED_FIELD;
const REMOVED_FIELD = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.removedField', {
  defaultMessage: 'removed'
});
exports.REMOVED_FIELD = REMOVED_FIELD;
const VIEW_INCIDENT = incidentNumber => _i18n.i18n.translate('xpack.cases.caseView.actionLabel.viewIncident', {
  defaultMessage: 'View {incidentNumber}',
  values: {
    incidentNumber
  }
});
exports.VIEW_INCIDENT = VIEW_INCIDENT;
const PUSHED_NEW_INCIDENT = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.pushedNewIncident', {
  defaultMessage: 'pushed as new incident'
});
exports.PUSHED_NEW_INCIDENT = PUSHED_NEW_INCIDENT;
const UPDATE_INCIDENT = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.updateIncident', {
  defaultMessage: 'updated incident'
});
exports.UPDATE_INCIDENT = UPDATE_INCIDENT;
const ADDED_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.addDescription', {
  defaultMessage: 'added description'
});
exports.ADDED_DESCRIPTION = ADDED_DESCRIPTION;
const EDIT_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.edit.description', {
  defaultMessage: 'Edit description'
});
exports.EDIT_DESCRIPTION = EDIT_DESCRIPTION;
const COLLAPSE_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.description.collapse', {
  defaultMessage: 'Collapse description'
});
exports.COLLAPSE_DESCRIPTION = COLLAPSE_DESCRIPTION;
const EXPAND_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.description.expand', {
  defaultMessage: 'Expand description'
});
exports.EXPAND_DESCRIPTION = EXPAND_DESCRIPTION;
const QUOTE = _i18n.i18n.translate('xpack.cases.caseView.edit.quote', {
  defaultMessage: 'Quote'
});
exports.QUOTE = QUOTE;
const EDIT_COMMENT = _i18n.i18n.translate('xpack.cases.caseView.edit.comment', {
  defaultMessage: 'Edit comment'
});
exports.EDIT_COMMENT = EDIT_COMMENT;
const DELETE_COMMENT = _i18n.i18n.translate('xpack.cases.caseView.delete.comment', {
  defaultMessage: 'Delete comment'
});
exports.DELETE_COMMENT = DELETE_COMMENT;
const DELETE_COMMENT_TITLE = _i18n.i18n.translate('xpack.cases.caseView.deleteTitle.comment', {
  defaultMessage: 'Delete this comment?'
});
exports.DELETE_COMMENT_TITLE = DELETE_COMMENT_TITLE;
const ON = _i18n.i18n.translate('xpack.cases.caseView.actionLabel.on', {
  defaultMessage: 'on'
});
exports.ON = ON;
const STATUS = _i18n.i18n.translate('xpack.cases.caseView.statusLabel', {
  defaultMessage: 'Status'
});
exports.STATUS = STATUS;
const CASE = _i18n.i18n.translate('xpack.cases.caseView.case', {
  defaultMessage: 'case'
});
exports.CASE = CASE;
const COMMENT = _i18n.i18n.translate('xpack.cases.caseView.comment', {
  defaultMessage: 'comment'
});
exports.COMMENT = COMMENT;
const CASE_REFRESH = _i18n.i18n.translate('xpack.cases.caseView.caseRefresh', {
  defaultMessage: 'Refresh case'
});
exports.CASE_REFRESH = CASE_REFRESH;
const ACTIVITY = _i18n.i18n.translate('xpack.cases.caseView.activity', {
  defaultMessage: 'Activity'
});
exports.ACTIVITY = ACTIVITY;
const EMAIL_SUBJECT = caseTitle => _i18n.i18n.translate('xpack.cases.caseView.emailSubject', {
  values: {
    caseTitle
  },
  defaultMessage: 'Security Case - {caseTitle}'
});
exports.EMAIL_SUBJECT = EMAIL_SUBJECT;
const EMAIL_BODY = caseUrl => _i18n.i18n.translate('xpack.cases.caseView.emailBody', {
  values: {
    caseUrl
  },
  defaultMessage: 'Case reference: {caseUrl}'
});
exports.EMAIL_BODY = EMAIL_BODY;
const CHANGED_CONNECTOR_FIELD = _i18n.i18n.translate('xpack.cases.caseView.fieldChanged', {
  defaultMessage: `changed connector field`
});
exports.CHANGED_CONNECTOR_FIELD = CHANGED_CONNECTOR_FIELD;
const SYNC_ALERTS = _i18n.i18n.translate('xpack.cases.caseView.syncAlertsLabel', {
  defaultMessage: `Sync alerts`
});
exports.SYNC_ALERTS = SYNC_ALERTS;
const SYNC_ALERTS_LC = _i18n.i18n.translate('xpack.cases.caseView.syncAlertsLowercaseLabel', {
  defaultMessage: `sync alerts`
});
exports.SYNC_ALERTS_LC = SYNC_ALERTS_LC;
const DOES_NOT_EXIST_TITLE = _i18n.i18n.translate('xpack.cases.caseView.doesNotExist.title', {
  defaultMessage: 'This case does not exist'
});
exports.DOES_NOT_EXIST_TITLE = DOES_NOT_EXIST_TITLE;
const DOES_NOT_EXIST_DESCRIPTION = caseId => _i18n.i18n.translate('xpack.cases.caseView.doesNotExist.description', {
  values: {
    caseId
  },
  defaultMessage: 'A case with id {caseId} could not be found. This likely means the case has been deleted, or the id is incorrect.'
});
exports.DOES_NOT_EXIST_DESCRIPTION = DOES_NOT_EXIST_DESCRIPTION;
const DOES_NOT_EXIST_BUTTON = _i18n.i18n.translate('xpack.cases.caseView.doesNotExist.button', {
  defaultMessage: 'Back to Cases'
});
exports.DOES_NOT_EXIST_BUTTON = DOES_NOT_EXIST_BUTTON;
const ACTIVITY_TAB = _i18n.i18n.translate('xpack.cases.caseView.tabs.activity', {
  defaultMessage: 'Activity'
});
exports.ACTIVITY_TAB = ACTIVITY_TAB;
const ALERTS_TAB = _i18n.i18n.translate('xpack.cases.caseView.tabs.alerts', {
  defaultMessage: 'Alerts'
});
exports.ALERTS_TAB = ALERTS_TAB;
const FILES_TAB = _i18n.i18n.translate('xpack.cases.caseView.tabs.files', {
  defaultMessage: 'Files'
});
exports.FILES_TAB = FILES_TAB;
const ALERTS_EMPTY_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.tabs.alerts.emptyDescription', {
  defaultMessage: 'No alerts have been added to this case.'
});
exports.ALERTS_EMPTY_DESCRIPTION = ALERTS_EMPTY_DESCRIPTION;
const SEND_EMAIL_ARIA = user => _i18n.i18n.translate('xpack.cases.caseView.sendEmalLinkAria', {
  values: {
    user
  },
  defaultMessage: 'click to send an email to {user}'
});
exports.SEND_EMAIL_ARIA = SEND_EMAIL_ARIA;
const EDIT_ASSIGNEES_ARIA_LABEL = _i18n.i18n.translate('xpack.cases.caseView.editAssigneesAriaLabel', {
  defaultMessage: 'click to edit assignees'
});
exports.EDIT_ASSIGNEES_ARIA_LABEL = EDIT_ASSIGNEES_ARIA_LABEL;
const NO_ASSIGNEES = _i18n.i18n.translate('xpack.cases.caseView.noAssignees', {
  defaultMessage: 'No users are assigned'
});
exports.NO_ASSIGNEES = NO_ASSIGNEES;
const ASSIGN_A_USER = _i18n.i18n.translate('xpack.cases.caseView.assignUser', {
  defaultMessage: 'Assign a user'
});
exports.ASSIGN_A_USER = ASSIGN_A_USER;
const SPACED_OR = _i18n.i18n.translate('xpack.cases.caseView.spacedOrText', {
  defaultMessage: ' or '
});
exports.SPACED_OR = SPACED_OR;
const ASSIGN_YOURSELF = _i18n.i18n.translate('xpack.cases.caseView.assignYourself', {
  defaultMessage: 'assign yourself'
});
exports.ASSIGN_YOURSELF = ASSIGN_YOURSELF;
const TOTAL_USERS_ASSIGNED = total => _i18n.i18n.translate('xpack.cases.caseView.totalUsersAssigned', {
  defaultMessage: '{total} assigned',
  values: {
    total
  }
});
exports.TOTAL_USERS_ASSIGNED = TOTAL_USERS_ASSIGNED;