"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseStatusMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _prettyMs = _interopRequireDefault(require("pretty-ms"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _translations = require("./translations");
var _maybe_date = require("../../formatted_date/maybe_date");
var _formatted_date = require("../../formatted_date");
var _empty_value = require("../../empty_value");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseStatusMetrics = /*#__PURE__*/_react.default.memo(({
  metrics,
  features
}) => {
  const lifespanMetrics = useGetLifespanMetrics(metrics, features);
  if (!lifespanMetrics) {
    return null;
  }
  const items = [{
    key: 'case-created',
    component: /*#__PURE__*/_react.default.createElement(CaseStatusMetricsItem, {
      title: _translations.CASE_CREATED,
      value: /*#__PURE__*/_react.default.createElement(CreationDate, {
        date: lifespanMetrics.creationDate
      })
    }),
    dataTestSubject: 'case-metrics-lifespan-item-creation-date'
  }, {
    key: 'in-progress-duration',
    component: /*#__PURE__*/_react.default.createElement(CaseStatusMetricsItem, {
      title: _translations.CASE_IN_PROGRESS_DURATION,
      value: getInProgressDuration(lifespanMetrics.statusInfo.inProgressDuration)
    }),
    dataTestSubject: 'case-metrics-lifespan-item-inProgress-duration'
  }, {
    key: 'open-duration',
    component: /*#__PURE__*/_react.default.createElement(CaseStatusMetricsItem, {
      title: _translations.CASE_OPEN_DURATION,
      value: formatDuration(lifespanMetrics.statusInfo.openDuration)
    }),
    dataTestSubject: 'case-metrics-lifespan-item-open-duration'
  }, {
    key: 'duration-from-creation-to-close',
    component: /*#__PURE__*/_react.default.createElement(CaseStatusMetricsOpenCloseDuration, {
      title: _translations.CASE_OPEN_TO_CLOSE_DURATION,
      value: getOpenCloseDuration(lifespanMetrics.creationDate, lifespanMetrics.closeDate),
      reopens: lifespanMetrics.statusInfo.reopenDates
    }),
    dataTestSubject: 'case-metrics-lifespan-item-open-to-close-duration'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    responsive: false
  }, items.map(({
    component,
    dataTestSubject,
    key
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSubject,
    key: key
  }, component))));
});
exports.CaseStatusMetrics = CaseStatusMetrics;
CaseStatusMetrics.displayName = 'CaseStatusMetrics';
const useGetLifespanMetrics = (metrics, features) => {
  return (0, _react.useMemo)(() => {
    var _metrics$lifespan;
    const lifespan = (_metrics$lifespan = metrics === null || metrics === void 0 ? void 0 : metrics.lifespan) !== null && _metrics$lifespan !== void 0 ? _metrics$lifespan : {
      closeDate: '',
      creationDate: '',
      statusInfo: {
        inProgressDuration: 0,
        reopenDates: [],
        openDuration: 0
      }
    };
    if (!features.includes('lifespan')) {
      return;
    }
    return lifespan;
  }, [features, metrics]);
};
const CreationDate = /*#__PURE__*/_react.default.memo(({
  date
}) => {
  const creationDate = (0, _maybe_date.getMaybeDate)(date);
  if (!creationDate.isValid()) {
    return (0, _empty_value.getEmptyTagValue)();
  }
  return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    "data-test-subj": 'case-metrics-lifespan-creation-date',
    value: date,
    stripMs: true
  });
});
CreationDate.displayName = 'CreationDate';
const getInProgressDuration = duration => {
  if (duration <= 0) {
    return (0, _empty_value.getEmptyTagValue)();
  }
  return formatDuration(duration);
};
const formatDuration = milliseconds => {
  return (0, _prettyMs.default)(milliseconds, {
    compact: true,
    verbose: true
  });
};
const getOpenCloseDuration = (openDate, closeDate) => {
  if (closeDate == null) {
    return;
  }
  const openDateObject = (0, _maybe_date.getMaybeDate)(openDate);
  const closeDateObject = (0, _maybe_date.getMaybeDate)(closeDate);
  if (!openDateObject.isValid() || !closeDateObject.isValid()) {
    return;
  }
  return formatDuration(closeDateObject.diff(openDateObject));
};
const Title = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  font-size: ${({
  theme
}) => theme.eui.euiSizeM};
  font-weight: bold;
`;
const CaseStatusMetricsItem = /*#__PURE__*/_react.default.memo(({
  title,
  value
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(Title, null, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, value)));
CaseStatusMetricsItem.displayName = 'CaseStatusMetricsItem';
const CaseStatusMetricsOpenCloseDuration = /*#__PURE__*/_react.default.memo(({
  title,
  value,
  reopens
}) => {
  const valueText = getOpenCloseDurationText(value, reopens);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(Title, null, title), value != null && caseWasReopened(reopens) ? /*#__PURE__*/_react.default.createElement(ValueWithExplanationIcon, {
    value: valueText,
    explanationValues: reopens
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, valueText));
});
CaseStatusMetricsOpenCloseDuration.displayName = 'OpenCloseDuration';
const getOpenCloseDurationText = (value, reopens) => {
  if (value == null) {
    return (0, _empty_value.getEmptyTagValue)();
  } else if (reopens.length > 0) {
    return `${value} ${_translations.CASE_REOPENED}`;
  }
  return value;
};
const caseWasReopened = reopens => {
  return reopens.length > 0;
};
const ValueWithExplanationIcon = /*#__PURE__*/_react.default.memo(({
  value,
  explanationValues
}) => {
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.CASE_REOPENED_ON, explanationValues.map((explanationValue, index) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: `explanation-value-${index}`
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      "data-test-subj": `case-metrics-lifespan-reopen-${index}`,
      value: explanationValue,
      stripMs: true
    }), isNotLastItem(index, explanationValues.length) ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }) : null);
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-metrics-lifespan-reopen-icon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, value), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: content,
    position: "right"
  }))));
});
ValueWithExplanationIcon.displayName = 'ValueWithExplanationIcon';
const isNotLastItem = (index, arrayLength) => index + 1 < arrayLength;