"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncAlertsSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../common/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncAlertsSwitchComponent = ({
  disabled,
  isSynced = true,
  showLabel = false,
  onSwitchChange
}) => {
  const [isOn, setIsOn] = (0, _react.useState)(isSynced);
  const onChange = (0, _react.useCallback)(() => {
    if (onSwitchChange) {
      onSwitchChange(!isOn);
    }
    setIsOn(!isOn);
  }, [isOn, onSwitchChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: isOn ? i18n.SYNC_ALERTS_SWITCH_LABEL_ON : i18n.SYNC_ALERTS_SWITCH_LABEL_OFF,
    showLabel: showLabel,
    checked: isOn,
    onChange: onChange,
    disabled: disabled,
    "data-test-subj": "sync-alerts-switch"
  });
};
SyncAlertsSwitchComponent.displayName = 'SyncAlertsSwitchComponent';
const SyncAlertsSwitch = /*#__PURE__*/(0, _react.memo)(SyncAlertsSwitchComponent);
exports.SyncAlertsSwitch = SyncAlertsSwitch;