"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _casesComponents = require("@kbn/cases-components");
var _api = require("../../../common/api");
var _status = require("../status");
var _translations = require("../all_cases/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusContextMenuComponent = ({
  currentStatus,
  disabled = false,
  isLoading = false,
  onStatusChanged
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(prevPopoverStatus => !prevPopoverStatus), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const popOverButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_status.StatusPopoverButton, {
    disabled: disabled || isLoading,
    status: currentStatus,
    onClick: togglePopover
  }), [disabled, currentStatus, togglePopover, isLoading]);
  const onContextMenuItemClick = (0, _react.useCallback)(status => {
    closePopover();
    if (currentStatus !== status) {
      onStatusChanged(status);
    }
  }, [closePopover, currentStatus, onStatusChanged]);
  const panelItems = (0, _react.useMemo)(() => _api.caseStatuses.map(status => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": `case-view-status-dropdown-${status}`,
    icon: status === currentStatus ? 'check' : 'empty',
    key: status,
    onClick: () => onContextMenuItemClick(status)
  }, /*#__PURE__*/_react.default.createElement(_casesComponents.Status, {
    status: status
  }))), [currentStatus, onContextMenuItemClick]);
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_casesComponents.Status, {
      status: currentStatus
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: popOverButton,
    closePopover: closePopover,
    "data-test-subj": "case-view-status-dropdown",
    id: "caseStatusPopover",
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    title: _translations.CHANGE_STATUS,
    items: panelItems
  }));
};
StatusContextMenuComponent.displayName = 'StatusContextMenu';
const StatusContextMenu = /*#__PURE__*/(0, _react.memo)(StatusContextMenuComponent);
exports.StatusContextMenu = StatusContextMenu;