"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseActionBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../case_view/translations"));
var _actions = require("./actions");
var _status_context_menu = require("./status_context_menu");
var _sync_alerts_switch = require("../case_settings/sync_alerts_switch");
var _formatted_date = require("../formatted_date");
var _helpers = require("./helpers");
var _use_on_refresh_case_view_page = require("../case_view/use_on_refresh_case_view_page");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cases_features = require("../../common/use_cases_features");
var _use_get_case_connectors = require("../../containers/use_get_case_connectors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyDescriptionList = (0, _styledComponents.default)(_eui.EuiDescriptionList)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    & {
      padding-right: ${theme.eui.euiSizeL};
      border-right: ${theme.eui.euiBorderThin};
      @media only screen and (max-width: ${theme.eui.euiBreakpoints.m}) {
        padding-right: 0;
        border-right: 0;
      }
    }
  `}
`;
const CaseActionBarComponent = ({
  caseData,
  isLoading,
  onUpdateField
}) => {
  var _caseConnectors$caseD, _caseConnectors$caseD2, _caseConnectors$caseD3;
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    isSyncAlertsEnabled,
    metricsFeatures
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    data: caseConnectors
  } = (0, _use_get_case_connectors.useGetCaseConnectors)(caseData.id);
  const date = (0, _helpers.getStatusDate)(caseData);
  const title = (0, _helpers.getStatusTitle)(caseData.status);
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  const onStatusChanged = (0, _react.useCallback)(status => onUpdateField({
    key: 'status',
    value: status
  }), [onUpdateField]);
  const currentExternalIncident = (_caseConnectors$caseD = caseConnectors === null || caseConnectors === void 0 ? void 0 : (_caseConnectors$caseD2 = caseConnectors[caseData.connector.id]) === null || _caseConnectors$caseD2 === void 0 ? void 0 : (_caseConnectors$caseD3 = _caseConnectors$caseD2.push.details) === null || _caseConnectors$caseD3 === void 0 ? void 0 : _caseConnectors$caseD3.externalService) !== null && _caseConnectors$caseD !== void 0 ? _caseConnectors$caseD : null;
  const onSyncAlertsChanged = (0, _react.useCallback)(syncAlerts => onUpdateField({
    key: 'settings',
    value: {
      ...caseData.settings,
      syncAlerts
    }
  }), [caseData.settings, onUpdateField]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    justifyContent: "flexEnd",
    "data-test-subj": "case-action-bar-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(MyDescriptionList, {
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "case-view-status"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, i18n.STATUS), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_status_context_menu.StatusContextMenu, {
    currentStatus: caseData.status,
    disabled: !permissions.update,
    isLoading: isLoading,
    onStatusChanged: onStatusChanged
  }))), !metricsFeatures.includes('lifespan') ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, title), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    "data-test-subj": 'case-action-bar-status-date',
    value: date
  }))) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "center",
    responsive: false,
    justifyContent: "spaceBetween"
  }, permissions.update && isSyncAlertsEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.SYNC_ALERTS)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: i18n.SYNC_ALERTS_HELP
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_sync_alerts_switch.SyncAlertsSwitch, {
    disabled: isLoading,
    isSynced: caseData.settings.syncAlerts,
    onSwitchChange: onSyncAlertsChanged
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "case-refresh",
    flush: "left",
    iconType: "refresh",
    onClick: refreshCaseViewPage
  }, i18n.CASE_REFRESH))), /*#__PURE__*/_react.default.createElement(_actions.Actions, {
    caseData: caseData,
    currentExternalIncident: currentExternalIncident
  })))));
};
CaseActionBarComponent.displayName = 'CaseActionBar';
const CaseActionBar = /*#__PURE__*/_react.default.memo(CaseActionBarComponent);
exports.CaseActionBar = CaseActionBar;