"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusTitle = exports.getStatusDate = void 0;
var _api = require("../../../common/api");
var _status = require("../status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStatusDate = theCase => {
  if (theCase.status === _api.CaseStatuses.open) {
    return theCase.createdAt;
  } else if (theCase.status === _api.CaseStatuses['in-progress']) {
    return theCase.updatedAt;
  } else if (theCase.status === _api.CaseStatuses.closed) {
    return theCase.closedAt;
  }
  return null;
};
exports.getStatusDate = getStatusDate;
const getStatusTitle = status => _status.statuses[status].actionBar.title;
exports.getStatusTitle = getStatusTitle;