"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CasesRoutes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactQuery = require("@tanstack/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _eui = require("@elastic/eui");
var _all_cases = require("../all_cases");
var _create = require("../create");
var _configure_cases = require("../configure_cases");
var _use_cases_context = require("../cases_context/use_cases_context");
var _navigation = require("../../common/navigation");
var _no_privileges = require("../no_privileges");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_readonly_header = require("./use_readonly_header");
var _query_client = require("../cases_context/query_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const CaseViewLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../case_view'))));
const CasesRoutesComponent = ({
  onComponentInitialized,
  actionsNavigation,
  ruleDetailsNavigation,
  showAlertDetails,
  useFetchAlertData,
  refreshRef,
  timelineIntegration
}) => {
  const {
    basePath,
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    navigateToAllCases
  } = (0, _navigation.useAllCasesNavigation)();
  const {
    navigateToCaseView
  } = (0, _navigation.useCaseViewNavigation)();
  (0, _use_readonly_header.useReadonlyHeader)();
  const onCreateCaseSuccess = (0, _react.useCallback)(async ({
    id
  }) => navigateToCaseView({
    detailName: id
  }), [navigateToCaseView]);
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.casesQueryClient
  }, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    exact: true,
    path: basePath
  }, /*#__PURE__*/_react.default.createElement(_all_cases.AllCases, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: (0, _navigation.getCreateCasePath)(basePath)
  }, permissions.create ? /*#__PURE__*/_react.default.createElement(_create.CreateCase, {
    onSuccess: onCreateCaseSuccess,
    onCancel: navigateToAllCases,
    timelineIntegration: timelineIntegration
  }) : /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
    pageName: i18n.CREATE_CASE_PAGE_NAME
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: (0, _navigation.getCasesConfigurePath)(basePath)
  }, permissions.update ? /*#__PURE__*/_react.default.createElement(_configure_cases.ConfigureCases, null) : /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
    pageName: i18n.CONFIGURE_CASES_PAGE_NAME
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [(0, _navigation.getCaseViewWithCommentPath)(basePath), (0, _navigation.getCaseViewPath)(basePath)]
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(CaseViewLazy, {
    onComponentInitialized: onComponentInitialized,
    actionsNavigation: actionsNavigation,
    ruleDetailsNavigation: ruleDetailsNavigation,
    showAlertDetails: showAlertDetails,
    useFetchAlertData: useFetchAlertData,
    refreshRef: refreshRef,
    timelineIntegration: timelineIntegration
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: basePath
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: basePath
  }))));
};
CasesRoutesComponent.displayName = 'CasesRoutes';
const CasesRoutes = /*#__PURE__*/_react.default.memo(CasesRoutesComponent);
// eslint-disable-next-line import/no-default-export
exports.default = exports.CasesRoutes = CasesRoutes;