"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  NO_CASES: true,
  NO_CASES_BODY: true,
  NO_CASES_BODY_READ_ONLY: true,
  SHOWING_SELECTED_CASES: true,
  SHOWING_CASES: true,
  UNIT: true,
  SEARCH_CASES: true,
  BULK_ACTIONS: true,
  EXTERNAL_INCIDENT: true,
  SEVERITY: true,
  INCIDENT_MANAGEMENT_SYSTEM: true,
  SEARCH_PLACEHOLDER: true,
  CLOSED: true,
  SELECT: true,
  REQUIRES_UPDATE: true,
  UP_TO_DATE: true,
  NOT_PUSHED: true,
  REFRESH: true,
  PUSH_LINK_ARIA: true,
  STATUS: true,
  CHANGE_STATUS: true,
  ATTC_STAT: true,
  ATTC_DESCRIPTION: true,
  FILTER_ASSIGNEES_ARIA_LABEL: true,
  CLEAR_FILTERS: true,
  TOTAL_ASSIGNEES_FILTERED: true,
  NO_ASSIGNEES: true,
  SHOW_LESS: true,
  SHOW_MORE: true,
  NO_ATTACHMENTS_ADDED: true
};
exports.UP_TO_DATE = exports.UNIT = exports.TOTAL_ASSIGNEES_FILTERED = exports.STATUS = exports.SHOW_MORE = exports.SHOW_LESS = exports.SHOWING_SELECTED_CASES = exports.SHOWING_CASES = exports.SEVERITY = exports.SELECT = exports.SEARCH_PLACEHOLDER = exports.SEARCH_CASES = exports.REQUIRES_UPDATE = exports.REFRESH = exports.PUSH_LINK_ARIA = exports.NO_CASES_BODY_READ_ONLY = exports.NO_CASES_BODY = exports.NO_CASES = exports.NO_ATTACHMENTS_ADDED = exports.NO_ASSIGNEES = exports.NOT_PUSHED = exports.INCIDENT_MANAGEMENT_SYSTEM = exports.FILTER_ASSIGNEES_ARIA_LABEL = exports.EXTERNAL_INCIDENT = exports.CLOSED = exports.CLEAR_FILTERS = exports.CHANGE_STATUS = exports.BULK_ACTIONS = exports.ATTC_STAT = exports.ATTC_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
var _translations2 = require("../user_profiles/translations");
Object.keys(_translations2).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations2[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations2[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_CASES = _i18n.i18n.translate('xpack.cases.caseTable.noCases.title', {
  defaultMessage: 'No cases to display'
});
exports.NO_CASES = NO_CASES;
const NO_CASES_BODY = _i18n.i18n.translate('xpack.cases.caseTable.noCases.body', {
  defaultMessage: 'Create a case or edit your filters.'
});
exports.NO_CASES_BODY = NO_CASES_BODY;
const NO_CASES_BODY_READ_ONLY = _i18n.i18n.translate('xpack.cases.caseTable.noCases.readonly.body', {
  defaultMessage: 'Edit your filter settings.'
});
exports.NO_CASES_BODY_READ_ONLY = NO_CASES_BODY_READ_ONLY;
const SHOWING_SELECTED_CASES = totalRules => _i18n.i18n.translate('xpack.cases.caseTable.selectedCasesTitle', {
  values: {
    totalRules
  },
  defaultMessage: 'Selected {totalRules} {totalRules, plural, =1 {case} other {cases}}'
});
exports.SHOWING_SELECTED_CASES = SHOWING_SELECTED_CASES;
const SHOWING_CASES = totalRules => _i18n.i18n.translate('xpack.cases.caseTable.showingCasesTitle', {
  values: {
    totalRules
  },
  defaultMessage: 'Showing {totalRules} {totalRules, plural, =1 {case} other {cases}}'
});
exports.SHOWING_CASES = SHOWING_CASES;
const UNIT = totalCount => _i18n.i18n.translate('xpack.cases.caseTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {case} other {cases}}`
});
exports.UNIT = UNIT;
const SEARCH_CASES = _i18n.i18n.translate('xpack.cases.caseTable.searchAriaLabel', {
  defaultMessage: 'Search cases'
});
exports.SEARCH_CASES = SEARCH_CASES;
const BULK_ACTIONS = _i18n.i18n.translate('xpack.cases.caseTable.bulkActions', {
  defaultMessage: 'Bulk actions'
});
exports.BULK_ACTIONS = BULK_ACTIONS;
const EXTERNAL_INCIDENT = _i18n.i18n.translate('xpack.cases.caseTable.snIncident', {
  defaultMessage: 'External incident'
});
exports.EXTERNAL_INCIDENT = EXTERNAL_INCIDENT;
const SEVERITY = _i18n.i18n.translate('xpack.cases.caseTable.severity', {
  defaultMessage: 'Severity'
});
exports.SEVERITY = SEVERITY;
const INCIDENT_MANAGEMENT_SYSTEM = _i18n.i18n.translate('xpack.cases.caseTable.incidentSystem', {
  defaultMessage: 'Incident management system'
});
exports.INCIDENT_MANAGEMENT_SYSTEM = INCIDENT_MANAGEMENT_SYSTEM;
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseTable.searchPlaceholder', {
  defaultMessage: 'Search cases'
});
exports.SEARCH_PLACEHOLDER = SEARCH_PLACEHOLDER;
const CLOSED = _i18n.i18n.translate('xpack.cases.caseTable.closed', {
  defaultMessage: 'Closed'
});
exports.CLOSED = CLOSED;
const SELECT = _i18n.i18n.translate('xpack.cases.caseTable.select', {
  defaultMessage: 'Select'
});
exports.SELECT = SELECT;
const REQUIRES_UPDATE = _i18n.i18n.translate('xpack.cases.caseTable.requiresUpdate', {
  defaultMessage: ' requires update'
});
exports.REQUIRES_UPDATE = REQUIRES_UPDATE;
const UP_TO_DATE = _i18n.i18n.translate('xpack.cases.caseTable.upToDate', {
  defaultMessage: ' is up to date'
});
exports.UP_TO_DATE = UP_TO_DATE;
const NOT_PUSHED = _i18n.i18n.translate('xpack.cases.caseTable.notPushed', {
  defaultMessage: 'Not pushed'
});
exports.NOT_PUSHED = NOT_PUSHED;
const REFRESH = _i18n.i18n.translate('xpack.cases.caseTable.refreshTitle', {
  defaultMessage: 'Refresh'
});
exports.REFRESH = REFRESH;
const PUSH_LINK_ARIA = thirdPartyName => _i18n.i18n.translate('xpack.cases.caseTable.pushLinkAria', {
  values: {
    thirdPartyName
  },
  defaultMessage: 'click to view the incident on { thirdPartyName }.'
});
exports.PUSH_LINK_ARIA = PUSH_LINK_ARIA;
const STATUS = _i18n.i18n.translate('xpack.cases.caseTable.status', {
  defaultMessage: 'Status'
});
exports.STATUS = STATUS;
const CHANGE_STATUS = _i18n.i18n.translate('xpack.cases.caseTable.changeStatus', {
  defaultMessage: 'Change status'
});
exports.CHANGE_STATUS = CHANGE_STATUS;
const ATTC_STAT = _i18n.i18n.translate('xpack.cases.casesStats.mttr', {
  defaultMessage: 'Average time to close'
});
exports.ATTC_STAT = ATTC_STAT;
const ATTC_DESCRIPTION = _i18n.i18n.translate('xpack.cases.casesStats.mttrDescription', {
  defaultMessage: 'The average duration (from creation to closure) for your current cases'
});
exports.ATTC_DESCRIPTION = ATTC_DESCRIPTION;
const FILTER_ASSIGNEES_ARIA_LABEL = _i18n.i18n.translate('xpack.cases.allCasesView.filterAssigneesAriaLabel', {
  defaultMessage: 'click to filter assignees'
});
exports.FILTER_ASSIGNEES_ARIA_LABEL = FILTER_ASSIGNEES_ARIA_LABEL;
const CLEAR_FILTERS = _i18n.i18n.translate('xpack.cases.allCasesView.filterAssignees.clearFilters', {
  defaultMessage: 'Clear filters'
});
exports.CLEAR_FILTERS = CLEAR_FILTERS;
const TOTAL_ASSIGNEES_FILTERED = total => _i18n.i18n.translate('xpack.cases.allCasesView.totalFilteredUsers', {
  defaultMessage: '{total, plural, one {# filter} other {# filters}} selected',
  values: {
    total
  }
});
exports.TOTAL_ASSIGNEES_FILTERED = TOTAL_ASSIGNEES_FILTERED;
const NO_ASSIGNEES = _i18n.i18n.translate('xpack.cases.allCasesView.filterAssignees.noAssigneesLabel', {
  defaultMessage: 'No assignees'
});
exports.NO_ASSIGNEES = NO_ASSIGNEES;
const SHOW_LESS = _i18n.i18n.translate('xpack.cases.allCasesView.showLessAvatars', {
  defaultMessage: 'show less'
});
exports.SHOW_LESS = SHOW_LESS;
const SHOW_MORE = count => _i18n.i18n.translate('xpack.cases.allCasesView.showMoreAvatars', {
  defaultMessage: '+{count} more',
  values: {
    count
  }
});
exports.SHOW_MORE = SHOW_MORE;
const NO_ATTACHMENTS_ADDED = _i18n.i18n.translate('xpack.cases.modal.attachments.noAttachmentsTitle', {
  defaultMessage: 'No attachments added to the case'
});
exports.NO_ATTACHMENTS_ADDED = NO_ATTACHMENTS_ADDED;