"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTableFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _types = require("../../../common/ui/types");
var _api = require("../../../common/api");
var _filter_popover = require("../filter_popover");
var _solution_filter = require("./solution_filter");
var _status_filter = require("./status_filter");
var i18n = _interopRequireWildcard(require("./translations"));
var _severity_filter = require("./severity_filter");
var _use_get_tags = require("../../containers/use_get_tags");
var _use_get_cases = require("../../containers/use_get_cases");
var _assignees_filter = require("./assignees_filter");
var _use_cases_features = require("../../common/use_cases_features");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Fix the width of the status dropdown to prevent hiding long text items
const StatusFilterWrapper = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  && {
    flex-basis: 180px;
  }
`;
const SeverityFilterWrapper = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  && {
    flex-basis: 180px;
  }
`;
const CasesTableFiltersComponent = ({
  countClosedCases,
  countOpenCases,
  countInProgressCases,
  onFilterChanged,
  initial = _use_get_cases.DEFAULT_FILTER_OPTIONS,
  hiddenStatuses,
  availableSolutions,
  isSelectorView = false,
  onCreateCasePressed,
  isLoading,
  currentUserProfile
}) => {
  const [search, setSearch] = (0, _react.useState)(initial.search);
  const [selectedTags, setSelectedTags] = (0, _react.useState)(initial.tags);
  const [selectedOwner, setSelectedOwner] = (0, _react.useState)([]);
  const [selectedAssignees, setSelectedAssignees] = (0, _react.useState)([]);
  const {
    data: tags = []
  } = (0, _use_get_tags.useGetTags)();
  const {
    caseAssignmentAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const handleSelectedAssignees = (0, _react.useCallback)(newAssignees => {
    if (!(0, _fp.isEqual)(newAssignees, selectedAssignees)) {
      setSelectedAssignees(newAssignees);
      onFilterChanged({
        assignees: newAssignees.map(assignee => {
          var _assignee$uid;
          return (_assignee$uid = assignee === null || assignee === void 0 ? void 0 : assignee.uid) !== null && _assignee$uid !== void 0 ? _assignee$uid : null;
        })
      });
    }
  }, [selectedAssignees, onFilterChanged]);
  const handleSelectedTags = (0, _react.useCallback)(newTags => {
    if (!(0, _fp.isEqual)(newTags, selectedTags)) {
      setSelectedTags(newTags);
      onFilterChanged({
        tags: newTags
      });
    }
  }, [onFilterChanged, selectedTags]);
  const handleSelectedSolution = (0, _react.useCallback)(newOwner => {
    if (!(0, _fp.isEqual)(newOwner, selectedOwner)) {
      setSelectedOwner(newOwner);
      onFilterChanged({
        owner: newOwner
      });
    }
  }, [onFilterChanged, selectedOwner]);
  (0, _react.useEffect)(() => {
    if (selectedTags.length) {
      const newTags = selectedTags.filter(t => tags.includes(t));
      handleSelectedTags(newTags);
    }
  }, [handleSelectedTags, selectedTags, tags]);
  const handleOnSearch = (0, _react.useCallback)(newSearch => {
    const trimSearch = newSearch.trim();
    if (!(0, _fp.isEqual)(trimSearch, search)) {
      setSearch(trimSearch);
      onFilterChanged({
        search: trimSearch
      });
    }
  }, [onFilterChanged, search]);
  const onStatusChanged = (0, _react.useCallback)(status => {
    onFilterChanged({
      status
    });
  }, [onFilterChanged]);
  const onSeverityChanged = (0, _react.useCallback)(severity => {
    onFilterChanged({
      severity
    });
  }, [onFilterChanged]);
  const stats = (0, _react.useMemo)(() => ({
    [_types.StatusAll]: null,
    [_api.CaseStatuses.open]: countOpenCases !== null && countOpenCases !== void 0 ? countOpenCases : 0,
    [_api.CaseStatuses['in-progress']]: countInProgressCases !== null && countInProgressCases !== void 0 ? countInProgressCases : 0,
    [_api.CaseStatuses.closed]: countClosedCases !== null && countClosedCases !== void 0 ? countClosedCases : 0
  }), [countClosedCases, countInProgressCases, countOpenCases]);
  const handleOnCreateCasePressed = (0, _react.useCallback)(() => {
    if (onCreateCasePressed) {
      onCreateCasePressed();
    }
  }, [onCreateCasePressed]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, isSelectorView && onCreateCasePressed ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: handleOnCreateCasePressed,
    iconType: "plusInCircle",
    "data-test-subj": "cases-table-add-case-filter-bar"
  }, i18n.CREATE_CASE_TITLE)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "aria-label": i18n.SEARCH_CASES,
    "data-test-subj": "search-cases",
    fullWidth: true,
    incremental: false,
    placeholder: i18n.SEARCH_PLACEHOLDER,
    onSearch: handleOnSearch
  })), /*#__PURE__*/_react.default.createElement(SeverityFilterWrapper, {
    grow: false,
    "data-test-subj": "severity-filter-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_severity_filter.SeverityFilter, {
    selectedSeverity: initial.severity,
    onSeverityChange: onSeverityChanged,
    isLoading: false,
    isDisabled: false
  })), /*#__PURE__*/_react.default.createElement(StatusFilterWrapper, {
    grow: false,
    "data-test-subj": "status-filter-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_status_filter.StatusFilter, {
    selectedStatus: initial.status,
    onStatusChanged: onStatusChanged,
    stats: stats,
    hiddenStatuses: hiddenStatuses
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, caseAssignmentAuthorized && !isSelectorView ? /*#__PURE__*/_react.default.createElement(_assignees_filter.AssigneesFilterPopover, {
    selectedAssignees: selectedAssignees,
    currentUserProfile: currentUserProfile,
    isLoading: isLoading,
    onSelectionChange: handleSelectedAssignees
  }) : null, /*#__PURE__*/_react.default.createElement(_filter_popover.FilterPopover, {
    buttonLabel: i18n.TAGS,
    onSelectedOptionsChanged: handleSelectedTags,
    selectedOptions: selectedTags,
    options: tags,
    optionsEmptyLabel: i18n.NO_TAGS_AVAILABLE
  }), availableSolutions.length > 1 && /*#__PURE__*/_react.default.createElement(_solution_filter.SolutionFilter, {
    onSelectedOptionsChanged: handleSelectedSolution,
    selectedOptions: selectedOwner,
    options: availableSolutions
  }))));
};
CasesTableFiltersComponent.displayName = 'CasesTableFiltersComponent';
const CasesTableFilters = /*#__PURE__*/_react.default.memo(CasesTableFiltersComponent);
exports.CasesTableFilters = CasesTableFilters;
CasesTableFilters.displayName = 'CasesTableFilters';